/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsOutputUpdate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class KinesisStreamsOutputUpdateMarshaller {
    private static final MarshallingInfo<String> RESOURCEARNUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceARNUpdate").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARNUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARNUpdate").isBinary(false).build();
    private static final KinesisStreamsOutputUpdateMarshaller INSTANCE = new KinesisStreamsOutputUpdateMarshaller();

    private KinesisStreamsOutputUpdateMarshaller() {
    }

    public static KinesisStreamsOutputUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KinesisStreamsOutputUpdate kinesisStreamsOutputUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)kinesisStreamsOutputUpdate, (String)"kinesisStreamsOutputUpdate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)kinesisStreamsOutputUpdate.resourceARNUpdate(), RESOURCEARNUPDATE_BINDING);
            protocolMarshaller.marshall((Object)kinesisStreamsOutputUpdate.roleARNUpdate(), ROLEARNUPDATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

