/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsInputUpdate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class KinesisStreamsInputUpdateMarshaller {
    private static final MarshallingInfo<String> RESOURCEARNUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceARNUpdate").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARNUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARNUpdate").isBinary(false).build();
    private static final KinesisStreamsInputUpdateMarshaller INSTANCE = new KinesisStreamsInputUpdateMarshaller();

    private KinesisStreamsInputUpdateMarshaller() {
    }

    public static KinesisStreamsInputUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KinesisStreamsInputUpdate kinesisStreamsInputUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)kinesisStreamsInputUpdate, (String)"kinesisStreamsInputUpdate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)kinesisStreamsInputUpdate.resourceARNUpdate(), RESOURCEARNUPDATE_BINDING);
            protocolMarshaller.marshall((Object)kinesisStreamsInputUpdate.roleARNUpdate(), ROLEARNUPDATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

