/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseOutput;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class KinesisFirehoseOutputMarshaller {
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceARN").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").isBinary(false).build();
    private static final KinesisFirehoseOutputMarshaller INSTANCE = new KinesisFirehoseOutputMarshaller();

    private KinesisFirehoseOutputMarshaller() {
    }

    public static KinesisFirehoseOutputMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KinesisFirehoseOutput kinesisFirehoseOutput, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)kinesisFirehoseOutput, (String)"kinesisFirehoseOutput");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)kinesisFirehoseOutput.resourceARN(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)kinesisFirehoseOutput.roleARN(), ROLEARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

