/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseInput;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class KinesisFirehoseInputMarshaller {
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceARN").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").isBinary(false).build();
    private static final KinesisFirehoseInputMarshaller INSTANCE = new KinesisFirehoseInputMarshaller();

    private KinesisFirehoseInputMarshaller() {
    }

    public static KinesisFirehoseInputMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KinesisFirehoseInput kinesisFirehoseInput, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)kinesisFirehoseInput, (String)"kinesisFirehoseInput");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)kinesisFirehoseInput.resourceARN(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)kinesisFirehoseInput.roleARN(), ROLEARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

