/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseInputDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class KinesisFirehoseInputDescriptionMarshaller {
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceARN").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").isBinary(false).build();
    private static final KinesisFirehoseInputDescriptionMarshaller INSTANCE = new KinesisFirehoseInputDescriptionMarshaller();

    private KinesisFirehoseInputDescriptionMarshaller() {
    }

    public static KinesisFirehoseInputDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KinesisFirehoseInputDescription kinesisFirehoseInputDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)kinesisFirehoseInputDescription, (String)"kinesisFirehoseInputDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)kinesisFirehoseInputDescription.resourceARN(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)kinesisFirehoseInputDescription.roleARN(), ROLEARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

