/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.InputSchemaUpdate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InputSchemaUpdateMarshaller {
    private static final MarshallingInfo<StructuredPojo> RECORDFORMATUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordFormatUpdate").isBinary(false).build();
    private static final MarshallingInfo<String> RECORDENCODINGUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordEncodingUpdate").isBinary(false).build();
    private static final MarshallingInfo<List> RECORDCOLUMNUPDATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordColumnUpdates").isBinary(false).build();
    private static final InputSchemaUpdateMarshaller INSTANCE = new InputSchemaUpdateMarshaller();

    private InputSchemaUpdateMarshaller() {
    }

    public static InputSchemaUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InputSchemaUpdate inputSchemaUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)inputSchemaUpdate, (String)"inputSchemaUpdate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)inputSchemaUpdate.recordFormatUpdate(), RECORDFORMATUPDATE_BINDING);
            protocolMarshaller.marshall((Object)inputSchemaUpdate.recordEncodingUpdate(), RECORDENCODINGUPDATE_BINDING);
            protocolMarshaller.marshall(inputSchemaUpdate.recordColumnUpdates(), RECORDCOLUMNUPDATES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

