/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.InputParallelism;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InputParallelismMarshaller {
    private static final MarshallingInfo<Integer> COUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Count").isBinary(false).build();
    private static final InputParallelismMarshaller INSTANCE = new InputParallelismMarshaller();

    private InputParallelismMarshaller() {
    }

    public static InputParallelismMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InputParallelism inputParallelism, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)inputParallelism, (String)"inputParallelism");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)inputParallelism.count(), COUNT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

