/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.Input;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InputMarshaller {
    private static final MarshallingInfo<String> NAMEPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NamePrefix").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INPUTPROCESSINGCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputProcessingConfiguration").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSINPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisStreamsInput").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> KINESISFIREHOSEINPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisFirehoseInput").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INPUTPARALLELISM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputParallelism").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INPUTSCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputSchema").isBinary(false).build();
    private static final InputMarshaller INSTANCE = new InputMarshaller();

    private InputMarshaller() {
    }

    public static InputMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Input input, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)input, (String)"input");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)input.namePrefix(), NAMEPREFIX_BINDING);
            protocolMarshaller.marshall((Object)input.inputProcessingConfiguration(), INPUTPROCESSINGCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)input.kinesisStreamsInput(), KINESISSTREAMSINPUT_BINDING);
            protocolMarshaller.marshall((Object)input.kinesisFirehoseInput(), KINESISFIREHOSEINPUT_BINDING);
            protocolMarshaller.marshall((Object)input.inputParallelism(), INPUTPARALLELISM_BINDING);
            protocolMarshaller.marshall((Object)input.inputSchema(), INPUTSCHEMA_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

