/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.InputDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InputDescriptionMarshaller {
    private static final MarshallingInfo<String> INPUTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputId").isBinary(false).build();
    private static final MarshallingInfo<String> NAMEPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NamePrefix").isBinary(false).build();
    private static final MarshallingInfo<List> INAPPSTREAMNAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InAppStreamNames").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INPUTPROCESSINGCONFIGURATIONDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputProcessingConfigurationDescription").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSINPUTDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisStreamsInputDescription").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> KINESISFIREHOSEINPUTDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisFirehoseInputDescription").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INPUTSCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputSchema").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INPUTPARALLELISM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputParallelism").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INPUTSTARTINGPOSITIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputStartingPositionConfiguration").isBinary(false).build();
    private static final InputDescriptionMarshaller INSTANCE = new InputDescriptionMarshaller();

    private InputDescriptionMarshaller() {
    }

    public static InputDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InputDescription inputDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)inputDescription, (String)"inputDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)inputDescription.inputId(), INPUTID_BINDING);
            protocolMarshaller.marshall((Object)inputDescription.namePrefix(), NAMEPREFIX_BINDING);
            protocolMarshaller.marshall(inputDescription.inAppStreamNames(), INAPPSTREAMNAMES_BINDING);
            protocolMarshaller.marshall((Object)inputDescription.inputProcessingConfigurationDescription(), INPUTPROCESSINGCONFIGURATIONDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)inputDescription.kinesisStreamsInputDescription(), KINESISSTREAMSINPUTDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)inputDescription.kinesisFirehoseInputDescription(), KINESISFIREHOSEINPUTDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)inputDescription.inputSchema(), INPUTSCHEMA_BINDING);
            protocolMarshaller.marshall((Object)inputDescription.inputParallelism(), INPUTPARALLELISM_BINDING);
            protocolMarshaller.marshall((Object)inputDescription.inputStartingPositionConfiguration(), INPUTSTARTINGPOSITIONCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

