/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.CreateApplicationRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateApplicationRequestModelMarshaller {
    private static final MarshallingInfo<String> APPLICATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationName").isBinary(false).build();
    private static final MarshallingInfo<String> APPLICATIONDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationDescription").isBinary(false).build();
    private static final MarshallingInfo<List> INPUTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Inputs").isBinary(false).build();
    private static final MarshallingInfo<List> OUTPUTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Outputs").isBinary(false).build();
    private static final MarshallingInfo<List> CLOUDWATCHLOGGINGOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudWatchLoggingOptions").isBinary(false).build();
    private static final MarshallingInfo<String> APPLICATIONCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationCode").isBinary(false).build();
    private static final CreateApplicationRequestModelMarshaller INSTANCE = new CreateApplicationRequestModelMarshaller();

    private CreateApplicationRequestModelMarshaller() {
    }

    public static CreateApplicationRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateApplicationRequest createApplicationRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createApplicationRequest), (String)"createApplicationRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createApplicationRequest.applicationName(), APPLICATIONNAME_BINDING);
            protocolMarshaller.marshall((Object)createApplicationRequest.applicationDescription(), APPLICATIONDESCRIPTION_BINDING);
            protocolMarshaller.marshall(createApplicationRequest.inputs(), INPUTS_BINDING);
            protocolMarshaller.marshall(createApplicationRequest.outputs(), OUTPUTS_BINDING);
            protocolMarshaller.marshall(createApplicationRequest.cloudWatchLoggingOptions(), CLOUDWATCHLOGGINGOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)createApplicationRequest.applicationCode(), APPLICATIONCODE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

