/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOption;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CloudWatchLoggingOptionMarshaller {
    private static final MarshallingInfo<String> LOGSTREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogStreamARN").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").isBinary(false).build();
    private static final CloudWatchLoggingOptionMarshaller INSTANCE = new CloudWatchLoggingOptionMarshaller();

    private CloudWatchLoggingOptionMarshaller() {
    }

    public static CloudWatchLoggingOptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CloudWatchLoggingOption cloudWatchLoggingOption, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)cloudWatchLoggingOption, (String)"cloudWatchLoggingOption");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)cloudWatchLoggingOption.logStreamARN(), LOGSTREAMARN_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLoggingOption.roleARN(), ROLEARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

