/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.ApplicationUpdate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ApplicationUpdateMarshaller {
    private static final MarshallingInfo<List> INPUTUPDATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputUpdates").isBinary(false).build();
    private static final MarshallingInfo<String> APPLICATIONCODEUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationCodeUpdate").isBinary(false).build();
    private static final MarshallingInfo<List> OUTPUTUPDATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputUpdates").isBinary(false).build();
    private static final MarshallingInfo<List> REFERENCEDATASOURCEUPDATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceDataSourceUpdates").isBinary(false).build();
    private static final MarshallingInfo<List> CLOUDWATCHLOGGINGOPTIONUPDATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudWatchLoggingOptionUpdates").isBinary(false).build();
    private static final ApplicationUpdateMarshaller INSTANCE = new ApplicationUpdateMarshaller();

    private ApplicationUpdateMarshaller() {
    }

    public static ApplicationUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ApplicationUpdate applicationUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)applicationUpdate, (String)"applicationUpdate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(applicationUpdate.inputUpdates(), INPUTUPDATES_BINDING);
            protocolMarshaller.marshall((Object)applicationUpdate.applicationCodeUpdate(), APPLICATIONCODEUPDATE_BINDING);
            protocolMarshaller.marshall(applicationUpdate.outputUpdates(), OUTPUTUPDATES_BINDING);
            protocolMarshaller.marshall(applicationUpdate.referenceDataSourceUpdates(), REFERENCEDATASOURCEUPDATES_BINDING);
            protocolMarshaller.marshall(applicationUpdate.cloudWatchLoggingOptionUpdates(), CLOUDWATCHLOGGINGOPTIONUPDATES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

