/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.ApplicationSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ApplicationSummaryMarshaller {
    private static final MarshallingInfo<String> APPLICATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationName").isBinary(false).build();
    private static final MarshallingInfo<String> APPLICATIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationARN").isBinary(false).build();
    private static final MarshallingInfo<String> APPLICATIONSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationStatus").isBinary(false).build();
    private static final ApplicationSummaryMarshaller INSTANCE = new ApplicationSummaryMarshaller();

    private ApplicationSummaryMarshaller() {
    }

    public static ApplicationSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ApplicationSummary applicationSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)applicationSummary, (String)"applicationSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)applicationSummary.applicationName(), APPLICATIONNAME_BINDING);
            protocolMarshaller.marshall((Object)applicationSummary.applicationARN(), APPLICATIONARN_BINDING);
            protocolMarshaller.marshall((Object)applicationSummary.applicationStatusAsString(), APPLICATIONSTATUS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

