/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.ApplicationDetail;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ApplicationDetailMarshaller {
    private static final MarshallingInfo<String> APPLICATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationName").isBinary(false).build();
    private static final MarshallingInfo<String> APPLICATIONDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationDescription").isBinary(false).build();
    private static final MarshallingInfo<String> APPLICATIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationARN").isBinary(false).build();
    private static final MarshallingInfo<String> APPLICATIONSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationStatus").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATETIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreateTimestamp").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTUPDATETIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdateTimestamp").isBinary(false).build();
    private static final MarshallingInfo<List> INPUTDESCRIPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputDescriptions").isBinary(false).build();
    private static final MarshallingInfo<List> OUTPUTDESCRIPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputDescriptions").isBinary(false).build();
    private static final MarshallingInfo<List> REFERENCEDATASOURCEDESCRIPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceDataSourceDescriptions").isBinary(false).build();
    private static final MarshallingInfo<List> CLOUDWATCHLOGGINGOPTIONDESCRIPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudWatchLoggingOptionDescriptions").isBinary(false).build();
    private static final MarshallingInfo<String> APPLICATIONCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationCode").isBinary(false).build();
    private static final MarshallingInfo<Long> APPLICATIONVERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationVersionId").isBinary(false).build();
    private static final ApplicationDetailMarshaller INSTANCE = new ApplicationDetailMarshaller();

    private ApplicationDetailMarshaller() {
    }

    public static ApplicationDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ApplicationDetail applicationDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)applicationDetail, (String)"applicationDetail");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)applicationDetail.applicationName(), APPLICATIONNAME_BINDING);
            protocolMarshaller.marshall((Object)applicationDetail.applicationDescription(), APPLICATIONDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)applicationDetail.applicationARN(), APPLICATIONARN_BINDING);
            protocolMarshaller.marshall((Object)applicationDetail.applicationStatusAsString(), APPLICATIONSTATUS_BINDING);
            protocolMarshaller.marshall((Object)applicationDetail.createTimestamp(), CREATETIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)applicationDetail.lastUpdateTimestamp(), LASTUPDATETIMESTAMP_BINDING);
            protocolMarshaller.marshall(applicationDetail.inputDescriptions(), INPUTDESCRIPTIONS_BINDING);
            protocolMarshaller.marshall(applicationDetail.outputDescriptions(), OUTPUTDESCRIPTIONS_BINDING);
            protocolMarshaller.marshall(applicationDetail.referenceDataSourceDescriptions(), REFERENCEDATASOURCEDESCRIPTIONS_BINDING);
            protocolMarshaller.marshall(applicationDetail.cloudWatchLoggingOptionDescriptions(), CLOUDWATCHLOGGINGOPTIONDESCRIPTIONS_BINDING);
            protocolMarshaller.marshall((Object)applicationDetail.applicationCode(), APPLICATIONCODE_BINDING);
            protocolMarshaller.marshall((Object)applicationDetail.applicationVersionId(), APPLICATIONVERSIONID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

