/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisAnalyticsException;
import software.amazon.awssdk.services.kinesisanalytics.model.ProcessedInputRecordsCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.RawInputRecordsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UnableToDetectSchemaException
extends KinesisAnalyticsException
implements ToCopyableBuilder<Builder, UnableToDetectSchemaException> {
    private final List<String> rawInputRecords;
    private final List<String> processedInputRecords;

    private UnableToDetectSchemaException(BuilderImpl builder) {
        super(builder);
        this.rawInputRecords = builder.rawInputRecords;
        this.processedInputRecords = builder.processedInputRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public List<String> rawInputRecords() {
        return this.rawInputRecords;
    }

    public List<String> processedInputRecords() {
        return this.processedInputRecords;
    }

    static final class BuilderImpl
    extends KinesisAnalyticsException.BuilderImpl
    implements Builder {
        private List<String> rawInputRecords = DefaultSdkAutoConstructList.getInstance();
        private List<String> processedInputRecords = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UnableToDetectSchemaException model) {
            super(model);
            this.rawInputRecords(model.rawInputRecords);
            this.processedInputRecords(model.processedInputRecords);
        }

        public final Collection<String> getRawInputRecords() {
            return this.rawInputRecords;
        }

        @Override
        public final Builder rawInputRecords(Collection<String> rawInputRecords) {
            this.rawInputRecords = RawInputRecordsCopier.copy(rawInputRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rawInputRecords(String ... rawInputRecords) {
            this.rawInputRecords(Arrays.asList(rawInputRecords));
            return this;
        }

        @JsonProperty(value="RawInputRecords")
        public final void setRawInputRecords(Collection<String> rawInputRecords) {
            this.rawInputRecords = RawInputRecordsCopier.copy(rawInputRecords);
        }

        public final Collection<String> getProcessedInputRecords() {
            return this.processedInputRecords;
        }

        @Override
        public final Builder processedInputRecords(Collection<String> processedInputRecords) {
            this.processedInputRecords = ProcessedInputRecordsCopier.copy(processedInputRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processedInputRecords(String ... processedInputRecords) {
            this.processedInputRecords(Arrays.asList(processedInputRecords));
            return this;
        }

        @JsonProperty(value="ProcessedInputRecords")
        public final void setProcessedInputRecords(Collection<String> processedInputRecords) {
            this.processedInputRecords = ProcessedInputRecordsCopier.copy(processedInputRecords);
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public UnableToDetectSchemaException build() {
            return new UnableToDetectSchemaException(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UnableToDetectSchemaException>,
    KinesisAnalyticsException.Builder {
        public Builder rawInputRecords(Collection<String> var1);

        public Builder rawInputRecords(String ... var1);

        public Builder processedInputRecords(Collection<String> var1);

        public Builder processedInputRecords(String ... var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);
    }
}

