/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.S3ReferenceDataSourceUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3ReferenceDataSourceUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, S3ReferenceDataSourceUpdate> {
    private final String bucketARNUpdate;
    private final String fileKeyUpdate;
    private final String referenceRoleARNUpdate;

    private S3ReferenceDataSourceUpdate(BuilderImpl builder) {
        this.bucketARNUpdate = builder.bucketARNUpdate;
        this.fileKeyUpdate = builder.fileKeyUpdate;
        this.referenceRoleARNUpdate = builder.referenceRoleARNUpdate;
    }

    public String bucketARNUpdate() {
        return this.bucketARNUpdate;
    }

    public String fileKeyUpdate() {
        return this.fileKeyUpdate;
    }

    public String referenceRoleARNUpdate() {
        return this.referenceRoleARNUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketARNUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileKeyUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceRoleARNUpdate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ReferenceDataSourceUpdate)) {
            return false;
        }
        S3ReferenceDataSourceUpdate other = (S3ReferenceDataSourceUpdate)obj;
        return Objects.equals(this.bucketARNUpdate(), other.bucketARNUpdate()) && Objects.equals(this.fileKeyUpdate(), other.fileKeyUpdate()) && Objects.equals(this.referenceRoleARNUpdate(), other.referenceRoleARNUpdate());
    }

    public String toString() {
        return ToString.builder((String)"S3ReferenceDataSourceUpdate").add("BucketARNUpdate", (Object)this.bucketARNUpdate()).add("FileKeyUpdate", (Object)this.fileKeyUpdate()).add("ReferenceRoleARNUpdate", (Object)this.referenceRoleARNUpdate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BucketARNUpdate": {
                return Optional.ofNullable(clazz.cast(this.bucketARNUpdate()));
            }
            case "FileKeyUpdate": {
                return Optional.ofNullable(clazz.cast(this.fileKeyUpdate()));
            }
            case "ReferenceRoleARNUpdate": {
                return Optional.ofNullable(clazz.cast(this.referenceRoleARNUpdate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ReferenceDataSourceUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketARNUpdate;
        private String fileKeyUpdate;
        private String referenceRoleARNUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ReferenceDataSourceUpdate model) {
            this.bucketARNUpdate(model.bucketARNUpdate);
            this.fileKeyUpdate(model.fileKeyUpdate);
            this.referenceRoleARNUpdate(model.referenceRoleARNUpdate);
        }

        public final String getBucketARNUpdate() {
            return this.bucketARNUpdate;
        }

        @Override
        public final Builder bucketARNUpdate(String bucketARNUpdate) {
            this.bucketARNUpdate = bucketARNUpdate;
            return this;
        }

        public final void setBucketARNUpdate(String bucketARNUpdate) {
            this.bucketARNUpdate = bucketARNUpdate;
        }

        public final String getFileKeyUpdate() {
            return this.fileKeyUpdate;
        }

        @Override
        public final Builder fileKeyUpdate(String fileKeyUpdate) {
            this.fileKeyUpdate = fileKeyUpdate;
            return this;
        }

        public final void setFileKeyUpdate(String fileKeyUpdate) {
            this.fileKeyUpdate = fileKeyUpdate;
        }

        public final String getReferenceRoleARNUpdate() {
            return this.referenceRoleARNUpdate;
        }

        @Override
        public final Builder referenceRoleARNUpdate(String referenceRoleARNUpdate) {
            this.referenceRoleARNUpdate = referenceRoleARNUpdate;
            return this;
        }

        public final void setReferenceRoleARNUpdate(String referenceRoleARNUpdate) {
            this.referenceRoleARNUpdate = referenceRoleARNUpdate;
        }

        public S3ReferenceDataSourceUpdate build() {
            return new S3ReferenceDataSourceUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3ReferenceDataSourceUpdate> {
        public Builder bucketARNUpdate(String var1);

        public Builder fileKeyUpdate(String var1);

        public Builder referenceRoleARNUpdate(String var1);
    }
}

