/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSource;
import software.amazon.awssdk.services.kinesisanalytics.model.SourceSchema;
import software.amazon.awssdk.services.kinesisanalytics.transform.ReferenceDataSourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReferenceDataSource
implements StructuredPojo,
ToCopyableBuilder<Builder, ReferenceDataSource> {
    private final String tableName;
    private final S3ReferenceDataSource s3ReferenceDataSource;
    private final SourceSchema referenceSchema;

    private ReferenceDataSource(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.s3ReferenceDataSource = builder.s3ReferenceDataSource;
        this.referenceSchema = builder.referenceSchema;
    }

    public String tableName() {
        return this.tableName;
    }

    public S3ReferenceDataSource s3ReferenceDataSource() {
        return this.s3ReferenceDataSource;
    }

    public SourceSchema referenceSchema() {
        return this.referenceSchema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ReferenceDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceSchema());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceDataSource)) {
            return false;
        }
        ReferenceDataSource other = (ReferenceDataSource)obj;
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.s3ReferenceDataSource(), other.s3ReferenceDataSource()) && Objects.equals(this.referenceSchema(), other.referenceSchema());
    }

    public String toString() {
        return ToString.builder((String)"ReferenceDataSource").add("TableName", (Object)this.tableName()).add("S3ReferenceDataSource", (Object)this.s3ReferenceDataSource()).add("ReferenceSchema", (Object)this.referenceSchema()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "S3ReferenceDataSource": {
                return Optional.ofNullable(clazz.cast(this.s3ReferenceDataSource()));
            }
            case "ReferenceSchema": {
                return Optional.ofNullable(clazz.cast(this.referenceSchema()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReferenceDataSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String tableName;
        private S3ReferenceDataSource s3ReferenceDataSource;
        private SourceSchema referenceSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceDataSource model) {
            this.tableName(model.tableName);
            this.s3ReferenceDataSource(model.s3ReferenceDataSource);
            this.referenceSchema(model.referenceSchema);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final S3ReferenceDataSource.Builder getS3ReferenceDataSource() {
            return this.s3ReferenceDataSource != null ? this.s3ReferenceDataSource.toBuilder() : null;
        }

        @Override
        public final Builder s3ReferenceDataSource(S3ReferenceDataSource s3ReferenceDataSource) {
            this.s3ReferenceDataSource = s3ReferenceDataSource;
            return this;
        }

        public final void setS3ReferenceDataSource(S3ReferenceDataSource.BuilderImpl s3ReferenceDataSource) {
            this.s3ReferenceDataSource = s3ReferenceDataSource != null ? s3ReferenceDataSource.build() : null;
        }

        public final SourceSchema.Builder getReferenceSchema() {
            return this.referenceSchema != null ? this.referenceSchema.toBuilder() : null;
        }

        @Override
        public final Builder referenceSchema(SourceSchema referenceSchema) {
            this.referenceSchema = referenceSchema;
            return this;
        }

        public final void setReferenceSchema(SourceSchema.BuilderImpl referenceSchema) {
            this.referenceSchema = referenceSchema != null ? referenceSchema.build() : null;
        }

        public ReferenceDataSource build() {
            return new ReferenceDataSource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReferenceDataSource> {
        public Builder tableName(String var1);

        public Builder s3ReferenceDataSource(S3ReferenceDataSource var1);

        default public Builder s3ReferenceDataSource(Consumer<S3ReferenceDataSource.Builder> s3ReferenceDataSource) {
            return this.s3ReferenceDataSource((S3ReferenceDataSource)((S3ReferenceDataSource.Builder)S3ReferenceDataSource.builder().applyMutation(s3ReferenceDataSource)).build());
        }

        public Builder referenceSchema(SourceSchema var1);

        default public Builder referenceSchema(Consumer<SourceSchema.Builder> referenceSchema) {
            return this.referenceSchema((SourceSchema)((SourceSchema.Builder)SourceSchema.builder().applyMutation(referenceSchema)).build());
        }
    }
}

