/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisAnalyticsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApplicationsRequest
extends KinesisAnalyticsRequest
implements ToCopyableBuilder<Builder, ListApplicationsRequest> {
    private final Integer limit;
    private final String exclusiveStartApplicationName;

    private ListApplicationsRequest(BuilderImpl builder) {
        super(builder);
        this.limit = builder.limit;
        this.exclusiveStartApplicationName = builder.exclusiveStartApplicationName;
    }

    public Integer limit() {
        return this.limit;
    }

    public String exclusiveStartApplicationName() {
        return this.exclusiveStartApplicationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveStartApplicationName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationsRequest)) {
            return false;
        }
        ListApplicationsRequest other = (ListApplicationsRequest)((Object)obj);
        return Objects.equals(this.limit(), other.limit()) && Objects.equals(this.exclusiveStartApplicationName(), other.exclusiveStartApplicationName());
    }

    public String toString() {
        return ToString.builder((String)"ListApplicationsRequest").add("Limit", (Object)this.limit()).add("ExclusiveStartApplicationName", (Object)this.exclusiveStartApplicationName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "ExclusiveStartApplicationName": {
                return Optional.ofNullable(clazz.cast(this.exclusiveStartApplicationName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisAnalyticsRequest.BuilderImpl
    implements Builder {
        private Integer limit;
        private String exclusiveStartApplicationName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationsRequest model) {
            super(model);
            this.limit(model.limit);
            this.exclusiveStartApplicationName(model.exclusiveStartApplicationName);
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getExclusiveStartApplicationName() {
            return this.exclusiveStartApplicationName;
        }

        @Override
        public final Builder exclusiveStartApplicationName(String exclusiveStartApplicationName) {
            this.exclusiveStartApplicationName = exclusiveStartApplicationName;
            return this;
        }

        public final void setExclusiveStartApplicationName(String exclusiveStartApplicationName) {
            this.exclusiveStartApplicationName = exclusiveStartApplicationName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListApplicationsRequest build() {
            return new ListApplicationsRequest(this);
        }
    }

    public static interface Builder
    extends KinesisAnalyticsRequest.Builder,
    CopyableBuilder<Builder, ListApplicationsRequest> {
        public Builder limit(Integer var1);

        public Builder exclusiveStartApplicationName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

