/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.KinesisFirehoseOutputUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KinesisFirehoseOutputUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, KinesisFirehoseOutputUpdate> {
    private final String resourceARNUpdate;
    private final String roleARNUpdate;

    private KinesisFirehoseOutputUpdate(BuilderImpl builder) {
        this.resourceARNUpdate = builder.resourceARNUpdate;
        this.roleARNUpdate = builder.roleARNUpdate;
    }

    public String resourceARNUpdate() {
        return this.resourceARNUpdate;
    }

    public String roleARNUpdate() {
        return this.roleARNUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceARNUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARNUpdate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisFirehoseOutputUpdate)) {
            return false;
        }
        KinesisFirehoseOutputUpdate other = (KinesisFirehoseOutputUpdate)obj;
        return Objects.equals(this.resourceARNUpdate(), other.resourceARNUpdate()) && Objects.equals(this.roleARNUpdate(), other.roleARNUpdate());
    }

    public String toString() {
        return ToString.builder((String)"KinesisFirehoseOutputUpdate").add("ResourceARNUpdate", (Object)this.resourceARNUpdate()).add("RoleARNUpdate", (Object)this.roleARNUpdate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceARNUpdate": {
                return Optional.ofNullable(clazz.cast(this.resourceARNUpdate()));
            }
            case "RoleARNUpdate": {
                return Optional.ofNullable(clazz.cast(this.roleARNUpdate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KinesisFirehoseOutputUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceARNUpdate;
        private String roleARNUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisFirehoseOutputUpdate model) {
            this.resourceARNUpdate(model.resourceARNUpdate);
            this.roleARNUpdate(model.roleARNUpdate);
        }

        public final String getResourceARNUpdate() {
            return this.resourceARNUpdate;
        }

        @Override
        public final Builder resourceARNUpdate(String resourceARNUpdate) {
            this.resourceARNUpdate = resourceARNUpdate;
            return this;
        }

        public final void setResourceARNUpdate(String resourceARNUpdate) {
            this.resourceARNUpdate = resourceARNUpdate;
        }

        public final String getRoleARNUpdate() {
            return this.roleARNUpdate;
        }

        @Override
        public final Builder roleARNUpdate(String roleARNUpdate) {
            this.roleARNUpdate = roleARNUpdate;
            return this;
        }

        public final void setRoleARNUpdate(String roleARNUpdate) {
            this.roleARNUpdate = roleARNUpdate;
        }

        public KinesisFirehoseOutputUpdate build() {
            return new KinesisFirehoseOutputUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KinesisFirehoseOutputUpdate> {
        public Builder resourceARNUpdate(String var1);

        public Builder roleARNUpdate(String var1);
    }
}

