/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.KinesisFirehoseInputDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KinesisFirehoseInputDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, KinesisFirehoseInputDescription> {
    private final String resourceARN;
    private final String roleARN;

    private KinesisFirehoseInputDescription(BuilderImpl builder) {
        this.resourceARN = builder.resourceARN;
        this.roleARN = builder.roleARN;
    }

    public String resourceARN() {
        return this.resourceARN;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisFirehoseInputDescription)) {
            return false;
        }
        KinesisFirehoseInputDescription other = (KinesisFirehoseInputDescription)obj;
        return Objects.equals(this.resourceARN(), other.resourceARN()) && Objects.equals(this.roleARN(), other.roleARN());
    }

    public String toString() {
        return ToString.builder((String)"KinesisFirehoseInputDescription").add("ResourceARN", (Object)this.resourceARN()).add("RoleARN", (Object)this.roleARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceARN": {
                return Optional.ofNullable(clazz.cast(this.resourceARN()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KinesisFirehoseInputDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceARN;
        private String roleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisFirehoseInputDescription model) {
            this.resourceARN(model.resourceARN);
            this.roleARN(model.roleARN);
        }

        public final String getResourceARN() {
            return this.resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public KinesisFirehoseInputDescription build() {
            return new KinesisFirehoseInputDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KinesisFirehoseInputDescription> {
        public Builder resourceARN(String var1);

        public Builder roleARN(String var1);
    }
}

