/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.InputParallelismUpdate;
import software.amazon.awssdk.services.kinesisanalytics.model.InputProcessingConfigurationUpdate;
import software.amazon.awssdk.services.kinesisanalytics.model.InputSchemaUpdate;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseInputUpdate;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsInputUpdate;
import software.amazon.awssdk.services.kinesisanalytics.transform.InputUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, InputUpdate> {
    private final String inputId;
    private final String namePrefixUpdate;
    private final InputProcessingConfigurationUpdate inputProcessingConfigurationUpdate;
    private final KinesisStreamsInputUpdate kinesisStreamsInputUpdate;
    private final KinesisFirehoseInputUpdate kinesisFirehoseInputUpdate;
    private final InputSchemaUpdate inputSchemaUpdate;
    private final InputParallelismUpdate inputParallelismUpdate;

    private InputUpdate(BuilderImpl builder) {
        this.inputId = builder.inputId;
        this.namePrefixUpdate = builder.namePrefixUpdate;
        this.inputProcessingConfigurationUpdate = builder.inputProcessingConfigurationUpdate;
        this.kinesisStreamsInputUpdate = builder.kinesisStreamsInputUpdate;
        this.kinesisFirehoseInputUpdate = builder.kinesisFirehoseInputUpdate;
        this.inputSchemaUpdate = builder.inputSchemaUpdate;
        this.inputParallelismUpdate = builder.inputParallelismUpdate;
    }

    public String inputId() {
        return this.inputId;
    }

    public String namePrefixUpdate() {
        return this.namePrefixUpdate;
    }

    public InputProcessingConfigurationUpdate inputProcessingConfigurationUpdate() {
        return this.inputProcessingConfigurationUpdate;
    }

    public KinesisStreamsInputUpdate kinesisStreamsInputUpdate() {
        return this.kinesisStreamsInputUpdate;
    }

    public KinesisFirehoseInputUpdate kinesisFirehoseInputUpdate() {
        return this.kinesisFirehoseInputUpdate;
    }

    public InputSchemaUpdate inputSchemaUpdate() {
        return this.inputSchemaUpdate;
    }

    public InputParallelismUpdate inputParallelismUpdate() {
        return this.inputParallelismUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputId());
        hashCode = 31 * hashCode + Objects.hashCode(this.namePrefixUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputProcessingConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamsInputUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisFirehoseInputUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSchemaUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputParallelismUpdate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputUpdate)) {
            return false;
        }
        InputUpdate other = (InputUpdate)obj;
        return Objects.equals(this.inputId(), other.inputId()) && Objects.equals(this.namePrefixUpdate(), other.namePrefixUpdate()) && Objects.equals(this.inputProcessingConfigurationUpdate(), other.inputProcessingConfigurationUpdate()) && Objects.equals(this.kinesisStreamsInputUpdate(), other.kinesisStreamsInputUpdate()) && Objects.equals(this.kinesisFirehoseInputUpdate(), other.kinesisFirehoseInputUpdate()) && Objects.equals(this.inputSchemaUpdate(), other.inputSchemaUpdate()) && Objects.equals(this.inputParallelismUpdate(), other.inputParallelismUpdate());
    }

    public String toString() {
        return ToString.builder((String)"InputUpdate").add("InputId", (Object)this.inputId()).add("NamePrefixUpdate", (Object)this.namePrefixUpdate()).add("InputProcessingConfigurationUpdate", (Object)this.inputProcessingConfigurationUpdate()).add("KinesisStreamsInputUpdate", (Object)this.kinesisStreamsInputUpdate()).add("KinesisFirehoseInputUpdate", (Object)this.kinesisFirehoseInputUpdate()).add("InputSchemaUpdate", (Object)this.inputSchemaUpdate()).add("InputParallelismUpdate", (Object)this.inputParallelismUpdate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputId": {
                return Optional.ofNullable(clazz.cast(this.inputId()));
            }
            case "NamePrefixUpdate": {
                return Optional.ofNullable(clazz.cast(this.namePrefixUpdate()));
            }
            case "InputProcessingConfigurationUpdate": {
                return Optional.ofNullable(clazz.cast(this.inputProcessingConfigurationUpdate()));
            }
            case "KinesisStreamsInputUpdate": {
                return Optional.ofNullable(clazz.cast(this.kinesisStreamsInputUpdate()));
            }
            case "KinesisFirehoseInputUpdate": {
                return Optional.ofNullable(clazz.cast(this.kinesisFirehoseInputUpdate()));
            }
            case "InputSchemaUpdate": {
                return Optional.ofNullable(clazz.cast(this.inputSchemaUpdate()));
            }
            case "InputParallelismUpdate": {
                return Optional.ofNullable(clazz.cast(this.inputParallelismUpdate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputId;
        private String namePrefixUpdate;
        private InputProcessingConfigurationUpdate inputProcessingConfigurationUpdate;
        private KinesisStreamsInputUpdate kinesisStreamsInputUpdate;
        private KinesisFirehoseInputUpdate kinesisFirehoseInputUpdate;
        private InputSchemaUpdate inputSchemaUpdate;
        private InputParallelismUpdate inputParallelismUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(InputUpdate model) {
            this.inputId(model.inputId);
            this.namePrefixUpdate(model.namePrefixUpdate);
            this.inputProcessingConfigurationUpdate(model.inputProcessingConfigurationUpdate);
            this.kinesisStreamsInputUpdate(model.kinesisStreamsInputUpdate);
            this.kinesisFirehoseInputUpdate(model.kinesisFirehoseInputUpdate);
            this.inputSchemaUpdate(model.inputSchemaUpdate);
            this.inputParallelismUpdate(model.inputParallelismUpdate);
        }

        public final String getInputId() {
            return this.inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        public final String getNamePrefixUpdate() {
            return this.namePrefixUpdate;
        }

        @Override
        public final Builder namePrefixUpdate(String namePrefixUpdate) {
            this.namePrefixUpdate = namePrefixUpdate;
            return this;
        }

        public final void setNamePrefixUpdate(String namePrefixUpdate) {
            this.namePrefixUpdate = namePrefixUpdate;
        }

        public final InputProcessingConfigurationUpdate.Builder getInputProcessingConfigurationUpdate() {
            return this.inputProcessingConfigurationUpdate != null ? this.inputProcessingConfigurationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder inputProcessingConfigurationUpdate(InputProcessingConfigurationUpdate inputProcessingConfigurationUpdate) {
            this.inputProcessingConfigurationUpdate = inputProcessingConfigurationUpdate;
            return this;
        }

        public final void setInputProcessingConfigurationUpdate(InputProcessingConfigurationUpdate.BuilderImpl inputProcessingConfigurationUpdate) {
            this.inputProcessingConfigurationUpdate = inputProcessingConfigurationUpdate != null ? inputProcessingConfigurationUpdate.build() : null;
        }

        public final KinesisStreamsInputUpdate.Builder getKinesisStreamsInputUpdate() {
            return this.kinesisStreamsInputUpdate != null ? this.kinesisStreamsInputUpdate.toBuilder() : null;
        }

        @Override
        public final Builder kinesisStreamsInputUpdate(KinesisStreamsInputUpdate kinesisStreamsInputUpdate) {
            this.kinesisStreamsInputUpdate = kinesisStreamsInputUpdate;
            return this;
        }

        public final void setKinesisStreamsInputUpdate(KinesisStreamsInputUpdate.BuilderImpl kinesisStreamsInputUpdate) {
            this.kinesisStreamsInputUpdate = kinesisStreamsInputUpdate != null ? kinesisStreamsInputUpdate.build() : null;
        }

        public final KinesisFirehoseInputUpdate.Builder getKinesisFirehoseInputUpdate() {
            return this.kinesisFirehoseInputUpdate != null ? this.kinesisFirehoseInputUpdate.toBuilder() : null;
        }

        @Override
        public final Builder kinesisFirehoseInputUpdate(KinesisFirehoseInputUpdate kinesisFirehoseInputUpdate) {
            this.kinesisFirehoseInputUpdate = kinesisFirehoseInputUpdate;
            return this;
        }

        public final void setKinesisFirehoseInputUpdate(KinesisFirehoseInputUpdate.BuilderImpl kinesisFirehoseInputUpdate) {
            this.kinesisFirehoseInputUpdate = kinesisFirehoseInputUpdate != null ? kinesisFirehoseInputUpdate.build() : null;
        }

        public final InputSchemaUpdate.Builder getInputSchemaUpdate() {
            return this.inputSchemaUpdate != null ? this.inputSchemaUpdate.toBuilder() : null;
        }

        @Override
        public final Builder inputSchemaUpdate(InputSchemaUpdate inputSchemaUpdate) {
            this.inputSchemaUpdate = inputSchemaUpdate;
            return this;
        }

        public final void setInputSchemaUpdate(InputSchemaUpdate.BuilderImpl inputSchemaUpdate) {
            this.inputSchemaUpdate = inputSchemaUpdate != null ? inputSchemaUpdate.build() : null;
        }

        public final InputParallelismUpdate.Builder getInputParallelismUpdate() {
            return this.inputParallelismUpdate != null ? this.inputParallelismUpdate.toBuilder() : null;
        }

        @Override
        public final Builder inputParallelismUpdate(InputParallelismUpdate inputParallelismUpdate) {
            this.inputParallelismUpdate = inputParallelismUpdate;
            return this;
        }

        public final void setInputParallelismUpdate(InputParallelismUpdate.BuilderImpl inputParallelismUpdate) {
            this.inputParallelismUpdate = inputParallelismUpdate != null ? inputParallelismUpdate.build() : null;
        }

        public InputUpdate build() {
            return new InputUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InputUpdate> {
        public Builder inputId(String var1);

        public Builder namePrefixUpdate(String var1);

        public Builder inputProcessingConfigurationUpdate(InputProcessingConfigurationUpdate var1);

        default public Builder inputProcessingConfigurationUpdate(Consumer<InputProcessingConfigurationUpdate.Builder> inputProcessingConfigurationUpdate) {
            return this.inputProcessingConfigurationUpdate((InputProcessingConfigurationUpdate)((InputProcessingConfigurationUpdate.Builder)InputProcessingConfigurationUpdate.builder().applyMutation(inputProcessingConfigurationUpdate)).build());
        }

        public Builder kinesisStreamsInputUpdate(KinesisStreamsInputUpdate var1);

        default public Builder kinesisStreamsInputUpdate(Consumer<KinesisStreamsInputUpdate.Builder> kinesisStreamsInputUpdate) {
            return this.kinesisStreamsInputUpdate((KinesisStreamsInputUpdate)((KinesisStreamsInputUpdate.Builder)KinesisStreamsInputUpdate.builder().applyMutation(kinesisStreamsInputUpdate)).build());
        }

        public Builder kinesisFirehoseInputUpdate(KinesisFirehoseInputUpdate var1);

        default public Builder kinesisFirehoseInputUpdate(Consumer<KinesisFirehoseInputUpdate.Builder> kinesisFirehoseInputUpdate) {
            return this.kinesisFirehoseInputUpdate((KinesisFirehoseInputUpdate)((KinesisFirehoseInputUpdate.Builder)KinesisFirehoseInputUpdate.builder().applyMutation(kinesisFirehoseInputUpdate)).build());
        }

        public Builder inputSchemaUpdate(InputSchemaUpdate var1);

        default public Builder inputSchemaUpdate(Consumer<InputSchemaUpdate.Builder> inputSchemaUpdate) {
            return this.inputSchemaUpdate((InputSchemaUpdate)((InputSchemaUpdate.Builder)InputSchemaUpdate.builder().applyMutation(inputSchemaUpdate)).build());
        }

        public Builder inputParallelismUpdate(InputParallelismUpdate var1);

        default public Builder inputParallelismUpdate(Consumer<InputParallelismUpdate.Builder> inputParallelismUpdate) {
            return this.inputParallelismUpdate((InputParallelismUpdate)((InputParallelismUpdate.Builder)InputParallelismUpdate.builder().applyMutation(inputParallelismUpdate)).build());
        }
    }
}

