/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.kinesisanalytics.model.InputProcessingConfiguration;
import software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPositionConfiguration;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisAnalyticsRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.S3Configuration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DiscoverInputSchemaRequest
extends KinesisAnalyticsRequest
implements ToCopyableBuilder<Builder, DiscoverInputSchemaRequest> {
    private final String resourceARN;
    private final String roleARN;
    private final InputStartingPositionConfiguration inputStartingPositionConfiguration;
    private final S3Configuration s3Configuration;
    private final InputProcessingConfiguration inputProcessingConfiguration;

    private DiscoverInputSchemaRequest(BuilderImpl builder) {
        super(builder);
        this.resourceARN = builder.resourceARN;
        this.roleARN = builder.roleARN;
        this.inputStartingPositionConfiguration = builder.inputStartingPositionConfiguration;
        this.s3Configuration = builder.s3Configuration;
        this.inputProcessingConfiguration = builder.inputProcessingConfiguration;
    }

    public String resourceARN() {
        return this.resourceARN;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public InputStartingPositionConfiguration inputStartingPositionConfiguration() {
        return this.inputStartingPositionConfiguration;
    }

    public S3Configuration s3Configuration() {
        return this.s3Configuration;
    }

    public InputProcessingConfiguration inputProcessingConfiguration() {
        return this.inputProcessingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputStartingPositionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputProcessingConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoverInputSchemaRequest)) {
            return false;
        }
        DiscoverInputSchemaRequest other = (DiscoverInputSchemaRequest)((Object)obj);
        return Objects.equals(this.resourceARN(), other.resourceARN()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.inputStartingPositionConfiguration(), other.inputStartingPositionConfiguration()) && Objects.equals(this.s3Configuration(), other.s3Configuration()) && Objects.equals(this.inputProcessingConfiguration(), other.inputProcessingConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"DiscoverInputSchemaRequest").add("ResourceARN", (Object)this.resourceARN()).add("RoleARN", (Object)this.roleARN()).add("InputStartingPositionConfiguration", (Object)this.inputStartingPositionConfiguration()).add("S3Configuration", (Object)this.s3Configuration()).add("InputProcessingConfiguration", (Object)this.inputProcessingConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceARN": {
                return Optional.ofNullable(clazz.cast(this.resourceARN()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "InputStartingPositionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inputStartingPositionConfiguration()));
            }
            case "S3Configuration": {
                return Optional.ofNullable(clazz.cast(this.s3Configuration()));
            }
            case "InputProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inputProcessingConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisAnalyticsRequest.BuilderImpl
    implements Builder {
        private String resourceARN;
        private String roleARN;
        private InputStartingPositionConfiguration inputStartingPositionConfiguration;
        private S3Configuration s3Configuration;
        private InputProcessingConfiguration inputProcessingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoverInputSchemaRequest model) {
            super(model);
            this.resourceARN(model.resourceARN);
            this.roleARN(model.roleARN);
            this.inputStartingPositionConfiguration(model.inputStartingPositionConfiguration);
            this.s3Configuration(model.s3Configuration);
            this.inputProcessingConfiguration(model.inputProcessingConfiguration);
        }

        public final String getResourceARN() {
            return this.resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final InputStartingPositionConfiguration.Builder getInputStartingPositionConfiguration() {
            return this.inputStartingPositionConfiguration != null ? this.inputStartingPositionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder inputStartingPositionConfiguration(InputStartingPositionConfiguration inputStartingPositionConfiguration) {
            this.inputStartingPositionConfiguration = inputStartingPositionConfiguration;
            return this;
        }

        public final void setInputStartingPositionConfiguration(InputStartingPositionConfiguration.BuilderImpl inputStartingPositionConfiguration) {
            this.inputStartingPositionConfiguration = inputStartingPositionConfiguration != null ? inputStartingPositionConfiguration.build() : null;
        }

        public final S3Configuration.Builder getS3Configuration() {
            return this.s3Configuration != null ? this.s3Configuration.toBuilder() : null;
        }

        @Override
        public final Builder s3Configuration(S3Configuration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final void setS3Configuration(S3Configuration.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        public final InputProcessingConfiguration.Builder getInputProcessingConfiguration() {
            return this.inputProcessingConfiguration != null ? this.inputProcessingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder inputProcessingConfiguration(InputProcessingConfiguration inputProcessingConfiguration) {
            this.inputProcessingConfiguration = inputProcessingConfiguration;
            return this;
        }

        public final void setInputProcessingConfiguration(InputProcessingConfiguration.BuilderImpl inputProcessingConfiguration) {
            this.inputProcessingConfiguration = inputProcessingConfiguration != null ? inputProcessingConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DiscoverInputSchemaRequest build() {
            return new DiscoverInputSchemaRequest(this);
        }
    }

    public static interface Builder
    extends KinesisAnalyticsRequest.Builder,
    CopyableBuilder<Builder, DiscoverInputSchemaRequest> {
        public Builder resourceARN(String var1);

        public Builder roleARN(String var1);

        public Builder inputStartingPositionConfiguration(InputStartingPositionConfiguration var1);

        default public Builder inputStartingPositionConfiguration(Consumer<InputStartingPositionConfiguration.Builder> inputStartingPositionConfiguration) {
            return this.inputStartingPositionConfiguration((InputStartingPositionConfiguration)((InputStartingPositionConfiguration.Builder)InputStartingPositionConfiguration.builder().applyMutation(inputStartingPositionConfiguration)).build());
        }

        public Builder s3Configuration(S3Configuration var1);

        default public Builder s3Configuration(Consumer<S3Configuration.Builder> s3Configuration) {
            return this.s3Configuration((S3Configuration)((S3Configuration.Builder)S3Configuration.builder().applyMutation(s3Configuration)).build());
        }

        public Builder inputProcessingConfiguration(InputProcessingConfiguration var1);

        default public Builder inputProcessingConfiguration(Consumer<InputProcessingConfiguration.Builder> inputProcessingConfiguration) {
            return this.inputProcessingConfiguration((InputProcessingConfiguration)((InputProcessingConfiguration.Builder)InputProcessingConfiguration.builder().applyMutation(inputProcessingConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

