/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.CloudWatchLoggingOptionDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudWatchLoggingOptionDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, CloudWatchLoggingOptionDescription> {
    private final String cloudWatchLoggingOptionId;
    private final String logStreamARN;
    private final String roleARN;

    private CloudWatchLoggingOptionDescription(BuilderImpl builder) {
        this.cloudWatchLoggingOptionId = builder.cloudWatchLoggingOptionId;
        this.logStreamARN = builder.logStreamARN;
        this.roleARN = builder.roleARN;
    }

    public String cloudWatchLoggingOptionId() {
        return this.cloudWatchLoggingOptionId;
    }

    public String logStreamARN() {
        return this.logStreamARN;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.logStreamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLoggingOptionDescription)) {
            return false;
        }
        CloudWatchLoggingOptionDescription other = (CloudWatchLoggingOptionDescription)obj;
        return Objects.equals(this.cloudWatchLoggingOptionId(), other.cloudWatchLoggingOptionId()) && Objects.equals(this.logStreamARN(), other.logStreamARN()) && Objects.equals(this.roleARN(), other.roleARN());
    }

    public String toString() {
        return ToString.builder((String)"CloudWatchLoggingOptionDescription").add("CloudWatchLoggingOptionId", (Object)this.cloudWatchLoggingOptionId()).add("LogStreamARN", (Object)this.logStreamARN()).add("RoleARN", (Object)this.roleARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudWatchLoggingOptionId": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptionId()));
            }
            case "LogStreamARN": {
                return Optional.ofNullable(clazz.cast(this.logStreamARN()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudWatchLoggingOptionDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String cloudWatchLoggingOptionId;
        private String logStreamARN;
        private String roleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLoggingOptionDescription model) {
            this.cloudWatchLoggingOptionId(model.cloudWatchLoggingOptionId);
            this.logStreamARN(model.logStreamARN);
            this.roleARN(model.roleARN);
        }

        public final String getCloudWatchLoggingOptionId() {
            return this.cloudWatchLoggingOptionId;
        }

        @Override
        public final Builder cloudWatchLoggingOptionId(String cloudWatchLoggingOptionId) {
            this.cloudWatchLoggingOptionId = cloudWatchLoggingOptionId;
            return this;
        }

        public final void setCloudWatchLoggingOptionId(String cloudWatchLoggingOptionId) {
            this.cloudWatchLoggingOptionId = cloudWatchLoggingOptionId;
        }

        public final String getLogStreamARN() {
            return this.logStreamARN;
        }

        @Override
        public final Builder logStreamARN(String logStreamARN) {
            this.logStreamARN = logStreamARN;
            return this;
        }

        public final void setLogStreamARN(String logStreamARN) {
            this.logStreamARN = logStreamARN;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public CloudWatchLoggingOptionDescription build() {
            return new CloudWatchLoggingOptionDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CloudWatchLoggingOptionDescription> {
        public Builder cloudWatchLoggingOptionId(String var1);

        public Builder logStreamARN(String var1);

        public Builder roleARN(String var1);
    }
}

