/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MergeShardsRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, MergeShardsRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MergeShardsRequest.getter(MergeShardsRequest::streamName)).setter(MergeShardsRequest.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<String> SHARD_TO_MERGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MergeShardsRequest.getter(MergeShardsRequest::shardToMerge)).setter(MergeShardsRequest.setter(Builder::shardToMerge)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardToMerge").build()}).build();
    private static final SdkField<String> ADJACENT_SHARD_TO_MERGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MergeShardsRequest.getter(MergeShardsRequest::adjacentShardToMerge)).setter(MergeShardsRequest.setter(Builder::adjacentShardToMerge)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdjacentShardToMerge").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, SHARD_TO_MERGE_FIELD, ADJACENT_SHARD_TO_MERGE_FIELD));
    private final String streamName;
    private final String shardToMerge;
    private final String adjacentShardToMerge;

    private MergeShardsRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.shardToMerge = builder.shardToMerge;
        this.adjacentShardToMerge = builder.adjacentShardToMerge;
    }

    public String streamName() {
        return this.streamName;
    }

    public String shardToMerge() {
        return this.shardToMerge;
    }

    public String adjacentShardToMerge() {
        return this.adjacentShardToMerge;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardToMerge());
        hashCode = 31 * hashCode + Objects.hashCode(this.adjacentShardToMerge());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeShardsRequest)) {
            return false;
        }
        MergeShardsRequest other = (MergeShardsRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.shardToMerge(), other.shardToMerge()) && Objects.equals(this.adjacentShardToMerge(), other.adjacentShardToMerge());
    }

    public String toString() {
        return ToString.builder((String)"MergeShardsRequest").add("StreamName", (Object)this.streamName()).add("ShardToMerge", (Object)this.shardToMerge()).add("AdjacentShardToMerge", (Object)this.adjacentShardToMerge()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "ShardToMerge": {
                return Optional.ofNullable(clazz.cast(this.shardToMerge()));
            }
            case "AdjacentShardToMerge": {
                return Optional.ofNullable(clazz.cast(this.adjacentShardToMerge()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MergeShardsRequest, T> g) {
        return obj -> g.apply((MergeShardsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private String shardToMerge;
        private String adjacentShardToMerge;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeShardsRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.shardToMerge(model.shardToMerge);
            this.adjacentShardToMerge(model.adjacentShardToMerge);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getShardToMerge() {
            return this.shardToMerge;
        }

        @Override
        public final Builder shardToMerge(String shardToMerge) {
            this.shardToMerge = shardToMerge;
            return this;
        }

        public final void setShardToMerge(String shardToMerge) {
            this.shardToMerge = shardToMerge;
        }

        public final String getAdjacentShardToMerge() {
            return this.adjacentShardToMerge;
        }

        @Override
        public final Builder adjacentShardToMerge(String adjacentShardToMerge) {
            this.adjacentShardToMerge = adjacentShardToMerge;
            return this;
        }

        public final void setAdjacentShardToMerge(String adjacentShardToMerge) {
            this.adjacentShardToMerge = adjacentShardToMerge;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MergeShardsRequest build() {
            return new MergeShardsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, MergeShardsRequest> {
        public Builder streamName(String var1);

        public Builder shardToMerge(String var1);

        public Builder adjacentShardToMerge(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

