/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesis.model.KinesisResponse;
import software.amazon.awssdk.services.kinesis.model.WarmThroughputObject;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStreamWarmThroughputResponse
extends KinesisResponse
implements ToCopyableBuilder<Builder, UpdateStreamWarmThroughputResponse> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamARN").getter(UpdateStreamWarmThroughputResponse.getter(UpdateStreamWarmThroughputResponse::streamARN)).setter(UpdateStreamWarmThroughputResponse.setter(Builder::streamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()}).build();
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamName").getter(UpdateStreamWarmThroughputResponse.getter(UpdateStreamWarmThroughputResponse::streamName)).setter(UpdateStreamWarmThroughputResponse.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<WarmThroughputObject> WARM_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WarmThroughput").getter(UpdateStreamWarmThroughputResponse.getter(UpdateStreamWarmThroughputResponse::warmThroughput)).setter(UpdateStreamWarmThroughputResponse.setter(Builder::warmThroughput)).constructor(WarmThroughputObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmThroughput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD, STREAM_NAME_FIELD, WARM_THROUGHPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateStreamWarmThroughputResponse.memberNameToFieldInitializer();
    private final String streamARN;
    private final String streamName;
    private final WarmThroughputObject warmThroughput;

    private UpdateStreamWarmThroughputResponse(BuilderImpl builder) {
        super(builder);
        this.streamARN = builder.streamARN;
        this.streamName = builder.streamName;
        this.warmThroughput = builder.warmThroughput;
    }

    public final String streamARN() {
        return this.streamARN;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final WarmThroughputObject warmThroughput() {
        return this.warmThroughput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.warmThroughput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStreamWarmThroughputResponse)) {
            return false;
        }
        UpdateStreamWarmThroughputResponse other = (UpdateStreamWarmThroughputResponse)((Object)obj);
        return Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.warmThroughput(), other.warmThroughput());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateStreamWarmThroughputResponse").add("StreamARN", (Object)this.streamARN()).add("StreamName", (Object)this.streamName()).add("WarmThroughput", (Object)this.warmThroughput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "WarmThroughput": {
                return Optional.ofNullable(clazz.cast(this.warmThroughput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StreamARN", STREAM_ARN_FIELD);
        map.put("StreamName", STREAM_NAME_FIELD);
        map.put("WarmThroughput", WARM_THROUGHPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateStreamWarmThroughputResponse, T> g) {
        return obj -> g.apply((UpdateStreamWarmThroughputResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisResponse.BuilderImpl
    implements Builder {
        private String streamARN;
        private String streamName;
        private WarmThroughputObject warmThroughput;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStreamWarmThroughputResponse model) {
            super(model);
            this.streamARN(model.streamARN);
            this.streamName(model.streamName);
            this.warmThroughput(model.warmThroughput);
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final WarmThroughputObject.Builder getWarmThroughput() {
            return this.warmThroughput != null ? this.warmThroughput.toBuilder() : null;
        }

        public final void setWarmThroughput(WarmThroughputObject.BuilderImpl warmThroughput) {
            this.warmThroughput = warmThroughput != null ? warmThroughput.build() : null;
        }

        @Override
        public final Builder warmThroughput(WarmThroughputObject warmThroughput) {
            this.warmThroughput = warmThroughput;
            return this;
        }

        @Override
        public UpdateStreamWarmThroughputResponse build() {
            return new UpdateStreamWarmThroughputResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KinesisResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateStreamWarmThroughputResponse> {
        public Builder streamARN(String var1);

        public Builder streamName(String var1);

        public Builder warmThroughput(WarmThroughputObject var1);

        default public Builder warmThroughput(Consumer<WarmThroughputObject.Builder> warmThroughput) {
            return this.warmThroughput((WarmThroughputObject)((WarmThroughputObject.Builder)WarmThroughputObject.builder().applyMutation(warmThroughput)).build());
        }
    }
}

