/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStreamWarmThroughputRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, UpdateStreamWarmThroughputRequest> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamARN").getter(UpdateStreamWarmThroughputRequest.getter(UpdateStreamWarmThroughputRequest::streamARN)).setter(UpdateStreamWarmThroughputRequest.setter(Builder::streamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()}).build();
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamName").getter(UpdateStreamWarmThroughputRequest.getter(UpdateStreamWarmThroughputRequest::streamName)).setter(UpdateStreamWarmThroughputRequest.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<Integer> WARM_THROUGHPUT_MI_BPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("WarmThroughputMiBps").getter(UpdateStreamWarmThroughputRequest.getter(UpdateStreamWarmThroughputRequest::warmThroughputMiBps)).setter(UpdateStreamWarmThroughputRequest.setter(Builder::warmThroughputMiBps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmThroughputMiBps").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD, STREAM_NAME_FIELD, WARM_THROUGHPUT_MI_BPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateStreamWarmThroughputRequest.memberNameToFieldInitializer();
    private final String streamARN;
    private final String streamName;
    private final Integer warmThroughputMiBps;

    private UpdateStreamWarmThroughputRequest(BuilderImpl builder) {
        super(builder);
        this.streamARN = builder.streamARN;
        this.streamName = builder.streamName;
        this.warmThroughputMiBps = builder.warmThroughputMiBps;
    }

    public final String streamARN() {
        return this.streamARN;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final Integer warmThroughputMiBps() {
        return this.warmThroughputMiBps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.warmThroughputMiBps());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStreamWarmThroughputRequest)) {
            return false;
        }
        UpdateStreamWarmThroughputRequest other = (UpdateStreamWarmThroughputRequest)((Object)obj);
        return Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.warmThroughputMiBps(), other.warmThroughputMiBps());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateStreamWarmThroughputRequest").add("StreamARN", (Object)this.streamARN()).add("StreamName", (Object)this.streamName()).add("WarmThroughputMiBps", (Object)this.warmThroughputMiBps()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "WarmThroughputMiBps": {
                return Optional.ofNullable(clazz.cast(this.warmThroughputMiBps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StreamARN", STREAM_ARN_FIELD);
        map.put("StreamName", STREAM_NAME_FIELD);
        map.put("WarmThroughputMiBps", WARM_THROUGHPUT_MI_BPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateStreamWarmThroughputRequest, T> g) {
        return obj -> g.apply((UpdateStreamWarmThroughputRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamARN;
        private String streamName;
        private Integer warmThroughputMiBps;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStreamWarmThroughputRequest model) {
            super(model);
            this.streamARN(model.streamARN);
            this.streamName(model.streamName);
            this.warmThroughputMiBps(model.warmThroughputMiBps);
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final Integer getWarmThroughputMiBps() {
            return this.warmThroughputMiBps;
        }

        public final void setWarmThroughputMiBps(Integer warmThroughputMiBps) {
            this.warmThroughputMiBps = warmThroughputMiBps;
        }

        @Override
        public final Builder warmThroughputMiBps(Integer warmThroughputMiBps) {
            this.warmThroughputMiBps = warmThroughputMiBps;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStreamWarmThroughputRequest build() {
            return new UpdateStreamWarmThroughputRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KinesisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateStreamWarmThroughputRequest> {
        public Builder streamARN(String var1);

        public Builder streamName(String var1);

        public Builder warmThroughputMiBps(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

