/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMaxRecordSizeRequest extends KinesisRequest implements
        ToCopyableBuilder<UpdateMaxRecordSizeRequest.Builder, UpdateMaxRecordSizeRequest> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(UpdateMaxRecordSizeRequest::streamARN)).setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final SdkField<Integer> MAX_RECORD_SIZE_IN_KIB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecordSizeInKiB").getter(getter(UpdateMaxRecordSizeRequest::maxRecordSizeInKiB))
            .setter(setter(Builder::maxRecordSizeInKiB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecordSizeInKiB").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD,
            MAX_RECORD_SIZE_IN_KIB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String streamARN;

    private final Integer maxRecordSizeInKiB;

    private UpdateMaxRecordSizeRequest(BuilderImpl builder) {
        super(builder);
        this.streamARN = builder.streamARN;
        this.maxRecordSizeInKiB = builder.maxRecordSizeInKiB;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the stream for the <code>MaxRecordSize</code> update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the stream for the <code>MaxRecordSize</code> update.
     */
    public final String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * The maximum record size of a single record in KiB that you can write to, and read from a stream. Specify a value
     * between 1024 and 10240 KiB (1 to 10 MiB). If you specify a value that is out of this range,
     * <code>UpdateMaxRecordSize</code> sends back an <code>ValidationException</code> message.
     * </p>
     * 
     * @return The maximum record size of a single record in KiB that you can write to, and read from a stream. Specify
     *         a value between 1024 and 10240 KiB (1 to 10 MiB). If you specify a value that is out of this range,
     *         <code>UpdateMaxRecordSize</code> sends back an <code>ValidationException</code> message.
     */
    public final Integer maxRecordSizeInKiB() {
        return maxRecordSizeInKiB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecordSizeInKiB());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMaxRecordSizeRequest)) {
            return false;
        }
        UpdateMaxRecordSizeRequest other = (UpdateMaxRecordSizeRequest) obj;
        return Objects.equals(streamARN(), other.streamARN()) && Objects.equals(maxRecordSizeInKiB(), other.maxRecordSizeInKiB());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMaxRecordSizeRequest").add("StreamARN", streamARN())
                .add("MaxRecordSizeInKiB", maxRecordSizeInKiB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        case "MaxRecordSizeInKiB":
            return Optional.ofNullable(clazz.cast(maxRecordSizeInKiB()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StreamARN", STREAM_ARN_FIELD);
        map.put("MaxRecordSizeInKiB", MAX_RECORD_SIZE_IN_KIB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMaxRecordSizeRequest, T> g) {
        return obj -> g.apply((UpdateMaxRecordSizeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KinesisRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateMaxRecordSizeRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the stream for the <code>MaxRecordSize</code> update.
         * </p>
         * 
         * @param streamARN
         *        The Amazon Resource Name (ARN) of the stream for the <code>MaxRecordSize</code> update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * The maximum record size of a single record in KiB that you can write to, and read from a stream. Specify a
         * value between 1024 and 10240 KiB (1 to 10 MiB). If you specify a value that is out of this range,
         * <code>UpdateMaxRecordSize</code> sends back an <code>ValidationException</code> message.
         * </p>
         * 
         * @param maxRecordSizeInKiB
         *        The maximum record size of a single record in KiB that you can write to, and read from a stream.
         *        Specify a value between 1024 and 10240 KiB (1 to 10 MiB). If you specify a value that is out of this
         *        range, <code>UpdateMaxRecordSize</code> sends back an <code>ValidationException</code> message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecordSizeInKiB(Integer maxRecordSizeInKiB);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisRequest.BuilderImpl implements Builder {
        private String streamARN;

        private Integer maxRecordSizeInKiB;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMaxRecordSizeRequest model) {
            super(model);
            streamARN(model.streamARN);
            maxRecordSizeInKiB(model.maxRecordSizeInKiB);
        }

        public final String getStreamARN() {
            return streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final Integer getMaxRecordSizeInKiB() {
            return maxRecordSizeInKiB;
        }

        public final void setMaxRecordSizeInKiB(Integer maxRecordSizeInKiB) {
            this.maxRecordSizeInKiB = maxRecordSizeInKiB;
        }

        @Override
        public final Builder maxRecordSizeInKiB(Integer maxRecordSizeInKiB) {
            this.maxRecordSizeInKiB = maxRecordSizeInKiB;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMaxRecordSizeRequest build() {
            return new UpdateMaxRecordSizeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
