/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAccountSettingsResponse extends KinesisResponse implements
        ToCopyableBuilder<UpdateAccountSettingsResponse.Builder, UpdateAccountSettingsResponse> {
    private static final SdkField<MinimumThroughputBillingCommitmentOutput> MINIMUM_THROUGHPUT_BILLING_COMMITMENT_FIELD = SdkField
            .<MinimumThroughputBillingCommitmentOutput> builder(MarshallingType.SDK_POJO)
            .memberName("MinimumThroughputBillingCommitment")
            .getter(getter(UpdateAccountSettingsResponse::minimumThroughputBillingCommitment))
            .setter(setter(Builder::minimumThroughputBillingCommitment))
            .constructor(MinimumThroughputBillingCommitmentOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumThroughputBillingCommitment")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MINIMUM_THROUGHPUT_BILLING_COMMITMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final MinimumThroughputBillingCommitmentOutput minimumThroughputBillingCommitment;

    private UpdateAccountSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.minimumThroughputBillingCommitment = builder.minimumThroughputBillingCommitment;
    }

    /**
     * <p>
     * The updated configuration of the minimum throughput billing commitment for your account.
     * </p>
     * 
     * @return The updated configuration of the minimum throughput billing commitment for your account.
     */
    public final MinimumThroughputBillingCommitmentOutput minimumThroughputBillingCommitment() {
        return minimumThroughputBillingCommitment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(minimumThroughputBillingCommitment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountSettingsResponse)) {
            return false;
        }
        UpdateAccountSettingsResponse other = (UpdateAccountSettingsResponse) obj;
        return Objects.equals(minimumThroughputBillingCommitment(), other.minimumThroughputBillingCommitment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAccountSettingsResponse")
                .add("MinimumThroughputBillingCommitment", minimumThroughputBillingCommitment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinimumThroughputBillingCommitment":
            return Optional.ofNullable(clazz.cast(minimumThroughputBillingCommitment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MinimumThroughputBillingCommitment", MINIMUM_THROUGHPUT_BILLING_COMMITMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccountSettingsResponse, T> g) {
        return obj -> g.apply((UpdateAccountSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KinesisResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAccountSettingsResponse> {
        /**
         * <p>
         * The updated configuration of the minimum throughput billing commitment for your account.
         * </p>
         * 
         * @param minimumThroughputBillingCommitment
         *        The updated configuration of the minimum throughput billing commitment for your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumThroughputBillingCommitment(MinimumThroughputBillingCommitmentOutput minimumThroughputBillingCommitment);

        /**
         * <p>
         * The updated configuration of the minimum throughput billing commitment for your account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MinimumThroughputBillingCommitmentOutput.Builder} avoiding the need to create one manually via
         * {@link MinimumThroughputBillingCommitmentOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MinimumThroughputBillingCommitmentOutput.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #minimumThroughputBillingCommitment(MinimumThroughputBillingCommitmentOutput)}.
         * 
         * @param minimumThroughputBillingCommitment
         *        a consumer that will call methods on {@link MinimumThroughputBillingCommitmentOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #minimumThroughputBillingCommitment(MinimumThroughputBillingCommitmentOutput)
         */
        default Builder minimumThroughputBillingCommitment(
                Consumer<MinimumThroughputBillingCommitmentOutput.Builder> minimumThroughputBillingCommitment) {
            return minimumThroughputBillingCommitment(MinimumThroughputBillingCommitmentOutput.builder()
                    .applyMutation(minimumThroughputBillingCommitment).build());
        }
    }

    static final class BuilderImpl extends KinesisResponse.BuilderImpl implements Builder {
        private MinimumThroughputBillingCommitmentOutput minimumThroughputBillingCommitment;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountSettingsResponse model) {
            super(model);
            minimumThroughputBillingCommitment(model.minimumThroughputBillingCommitment);
        }

        public final MinimumThroughputBillingCommitmentOutput.Builder getMinimumThroughputBillingCommitment() {
            return minimumThroughputBillingCommitment != null ? minimumThroughputBillingCommitment.toBuilder() : null;
        }

        public final void setMinimumThroughputBillingCommitment(
                MinimumThroughputBillingCommitmentOutput.BuilderImpl minimumThroughputBillingCommitment) {
            this.minimumThroughputBillingCommitment = minimumThroughputBillingCommitment != null ? minimumThroughputBillingCommitment
                    .build() : null;
        }

        @Override
        public final Builder minimumThroughputBillingCommitment(
                MinimumThroughputBillingCommitmentOutput minimumThroughputBillingCommitment) {
            this.minimumThroughputBillingCommitment = minimumThroughputBillingCommitment;
            return this;
        }

        @Override
        public UpdateAccountSettingsResponse build() {
            return new UpdateAccountSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
