/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request parameter used to filter out the response of the <code>ListShards</code> API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ShardFilter implements SdkPojo, Serializable, ToCopyableBuilder<ShardFilter.Builder, ShardFilter> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ShardFilter::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> SHARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShardId").getter(getter(ShardFilter::shardId)).setter(setter(Builder::shardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardId").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(ShardFilter::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, SHARD_ID_FIELD,
            TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String shardId;

    private final Instant timestamp;

    private ShardFilter(BuilderImpl builder) {
        this.type = builder.type;
        this.shardId = builder.shardId;
        this.timestamp = builder.timestamp;
    }

    /**
     * <p>
     * The shard type specified in the <code>ShardFilter</code> parameter. This is a required property of the
     * <code>ShardFilter</code> parameter.
     * </p>
     * <p>
     * You can specify the following valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AFTER_SHARD_ID</code> - the response includes all the shards, starting with the shard whose ID immediately
     * follows the <code>ShardId</code> that you provided.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AT_TRIM_HORIZON</code> - the response includes all the shards that were open at <code>TRIM_HORIZON</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FROM_TRIM_HORIZON</code> - (default), the response includes all the shards within the retention period of
     * the data stream (trim to tip).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AT_LATEST</code> - the response includes only the currently open shards of the data stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AT_TIMESTAMP</code> - the response includes all shards whose start timestamp is less than or equal to the
     * given timestamp and end timestamp is greater than or equal to the given timestamp or still open.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FROM_TIMESTAMP</code> - the response incldues all closed shards whose end timestamp is greater than or
     * equal to the given timestamp and also all open shards. Corrected to <code>TRIM_HORIZON</code> of the data stream
     * if <code>FROM_TIMESTAMP</code> is less than the <code>TRIM_HORIZON</code> value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ShardFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The shard type specified in the <code>ShardFilter</code> parameter. This is a required property of the
     *         <code>ShardFilter</code> parameter.</p>
     *         <p>
     *         You can specify the following valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AFTER_SHARD_ID</code> - the response includes all the shards, starting with the shard whose ID
     *         immediately follows the <code>ShardId</code> that you provided.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AT_TRIM_HORIZON</code> - the response includes all the shards that were open at
     *         <code>TRIM_HORIZON</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FROM_TRIM_HORIZON</code> - (default), the response includes all the shards within the retention
     *         period of the data stream (trim to tip).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AT_LATEST</code> - the response includes only the currently open shards of the data stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AT_TIMESTAMP</code> - the response includes all shards whose start timestamp is less than or equal
     *         to the given timestamp and end timestamp is greater than or equal to the given timestamp or still open.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FROM_TIMESTAMP</code> - the response incldues all closed shards whose end timestamp is greater than
     *         or equal to the given timestamp and also all open shards. Corrected to <code>TRIM_HORIZON</code> of the
     *         data stream if <code>FROM_TIMESTAMP</code> is less than the <code>TRIM_HORIZON</code> value.
     *         </p>
     *         </li>
     * @see ShardFilterType
     */
    public final ShardFilterType type() {
        return ShardFilterType.fromValue(type);
    }

    /**
     * <p>
     * The shard type specified in the <code>ShardFilter</code> parameter. This is a required property of the
     * <code>ShardFilter</code> parameter.
     * </p>
     * <p>
     * You can specify the following valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AFTER_SHARD_ID</code> - the response includes all the shards, starting with the shard whose ID immediately
     * follows the <code>ShardId</code> that you provided.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AT_TRIM_HORIZON</code> - the response includes all the shards that were open at <code>TRIM_HORIZON</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FROM_TRIM_HORIZON</code> - (default), the response includes all the shards within the retention period of
     * the data stream (trim to tip).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AT_LATEST</code> - the response includes only the currently open shards of the data stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AT_TIMESTAMP</code> - the response includes all shards whose start timestamp is less than or equal to the
     * given timestamp and end timestamp is greater than or equal to the given timestamp or still open.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FROM_TIMESTAMP</code> - the response incldues all closed shards whose end timestamp is greater than or
     * equal to the given timestamp and also all open shards. Corrected to <code>TRIM_HORIZON</code> of the data stream
     * if <code>FROM_TIMESTAMP</code> is less than the <code>TRIM_HORIZON</code> value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ShardFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The shard type specified in the <code>ShardFilter</code> parameter. This is a required property of the
     *         <code>ShardFilter</code> parameter.</p>
     *         <p>
     *         You can specify the following valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AFTER_SHARD_ID</code> - the response includes all the shards, starting with the shard whose ID
     *         immediately follows the <code>ShardId</code> that you provided.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AT_TRIM_HORIZON</code> - the response includes all the shards that were open at
     *         <code>TRIM_HORIZON</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FROM_TRIM_HORIZON</code> - (default), the response includes all the shards within the retention
     *         period of the data stream (trim to tip).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AT_LATEST</code> - the response includes only the currently open shards of the data stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AT_TIMESTAMP</code> - the response includes all shards whose start timestamp is less than or equal
     *         to the given timestamp and end timestamp is greater than or equal to the given timestamp or still open.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FROM_TIMESTAMP</code> - the response incldues all closed shards whose end timestamp is greater than
     *         or equal to the given timestamp and also all open shards. Corrected to <code>TRIM_HORIZON</code> of the
     *         data stream if <code>FROM_TIMESTAMP</code> is less than the <code>TRIM_HORIZON</code> value.
     *         </p>
     *         </li>
     * @see ShardFilterType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The exclusive start <code>shardID</code> speified in the <code>ShardFilter</code> parameter. This property can
     * only be used if the <code>AFTER_SHARD_ID</code> shard type is specified.
     * </p>
     * 
     * @return The exclusive start <code>shardID</code> speified in the <code>ShardFilter</code> parameter. This
     *         property can only be used if the <code>AFTER_SHARD_ID</code> shard type is specified.
     */
    public final String shardId() {
        return shardId;
    }

    /**
     * <p>
     * The timestamps specified in the <code>ShardFilter</code> parameter. A timestamp is a Unix epoch date with
     * precision in milliseconds. For example, 2016-04-04T19:58:46.480-00:00 or 1459799926.480. This property can only
     * be used if <code>FROM_TIMESTAMP</code> or <code>AT_TIMESTAMP</code> shard types are specified.
     * </p>
     * 
     * @return The timestamps specified in the <code>ShardFilter</code> parameter. A timestamp is a Unix epoch date with
     *         precision in milliseconds. For example, 2016-04-04T19:58:46.480-00:00 or 1459799926.480. This property
     *         can only be used if <code>FROM_TIMESTAMP</code> or <code>AT_TIMESTAMP</code> shard types are specified.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(shardId());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShardFilter)) {
            return false;
        }
        ShardFilter other = (ShardFilter) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(shardId(), other.shardId())
                && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ShardFilter").add("Type", typeAsString()).add("ShardId", shardId())
                .add("Timestamp", timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ShardId":
            return Optional.ofNullable(clazz.cast(shardId()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("ShardId", SHARD_ID_FIELD);
        map.put("Timestamp", TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ShardFilter, T> g) {
        return obj -> g.apply((ShardFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ShardFilter> {
        /**
         * <p>
         * The shard type specified in the <code>ShardFilter</code> parameter. This is a required property of the
         * <code>ShardFilter</code> parameter.
         * </p>
         * <p>
         * You can specify the following valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AFTER_SHARD_ID</code> - the response includes all the shards, starting with the shard whose ID
         * immediately follows the <code>ShardId</code> that you provided.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AT_TRIM_HORIZON</code> - the response includes all the shards that were open at
         * <code>TRIM_HORIZON</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FROM_TRIM_HORIZON</code> - (default), the response includes all the shards within the retention period
         * of the data stream (trim to tip).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AT_LATEST</code> - the response includes only the currently open shards of the data stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AT_TIMESTAMP</code> - the response includes all shards whose start timestamp is less than or equal to
         * the given timestamp and end timestamp is greater than or equal to the given timestamp or still open.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FROM_TIMESTAMP</code> - the response incldues all closed shards whose end timestamp is greater than or
         * equal to the given timestamp and also all open shards. Corrected to <code>TRIM_HORIZON</code> of the data
         * stream if <code>FROM_TIMESTAMP</code> is less than the <code>TRIM_HORIZON</code> value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The shard type specified in the <code>ShardFilter</code> parameter. This is a required property of the
         *        <code>ShardFilter</code> parameter.</p>
         *        <p>
         *        You can specify the following valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AFTER_SHARD_ID</code> - the response includes all the shards, starting with the shard whose ID
         *        immediately follows the <code>ShardId</code> that you provided.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AT_TRIM_HORIZON</code> - the response includes all the shards that were open at
         *        <code>TRIM_HORIZON</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FROM_TRIM_HORIZON</code> - (default), the response includes all the shards within the retention
         *        period of the data stream (trim to tip).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AT_LATEST</code> - the response includes only the currently open shards of the data stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AT_TIMESTAMP</code> - the response includes all shards whose start timestamp is less than or
         *        equal to the given timestamp and end timestamp is greater than or equal to the given timestamp or
         *        still open.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FROM_TIMESTAMP</code> - the response incldues all closed shards whose end timestamp is greater
         *        than or equal to the given timestamp and also all open shards. Corrected to <code>TRIM_HORIZON</code>
         *        of the data stream if <code>FROM_TIMESTAMP</code> is less than the <code>TRIM_HORIZON</code> value.
         *        </p>
         *        </li>
         * @see ShardFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShardFilterType
         */
        Builder type(String type);

        /**
         * <p>
         * The shard type specified in the <code>ShardFilter</code> parameter. This is a required property of the
         * <code>ShardFilter</code> parameter.
         * </p>
         * <p>
         * You can specify the following valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AFTER_SHARD_ID</code> - the response includes all the shards, starting with the shard whose ID
         * immediately follows the <code>ShardId</code> that you provided.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AT_TRIM_HORIZON</code> - the response includes all the shards that were open at
         * <code>TRIM_HORIZON</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FROM_TRIM_HORIZON</code> - (default), the response includes all the shards within the retention period
         * of the data stream (trim to tip).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AT_LATEST</code> - the response includes only the currently open shards of the data stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AT_TIMESTAMP</code> - the response includes all shards whose start timestamp is less than or equal to
         * the given timestamp and end timestamp is greater than or equal to the given timestamp or still open.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FROM_TIMESTAMP</code> - the response incldues all closed shards whose end timestamp is greater than or
         * equal to the given timestamp and also all open shards. Corrected to <code>TRIM_HORIZON</code> of the data
         * stream if <code>FROM_TIMESTAMP</code> is less than the <code>TRIM_HORIZON</code> value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The shard type specified in the <code>ShardFilter</code> parameter. This is a required property of the
         *        <code>ShardFilter</code> parameter.</p>
         *        <p>
         *        You can specify the following valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AFTER_SHARD_ID</code> - the response includes all the shards, starting with the shard whose ID
         *        immediately follows the <code>ShardId</code> that you provided.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AT_TRIM_HORIZON</code> - the response includes all the shards that were open at
         *        <code>TRIM_HORIZON</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FROM_TRIM_HORIZON</code> - (default), the response includes all the shards within the retention
         *        period of the data stream (trim to tip).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AT_LATEST</code> - the response includes only the currently open shards of the data stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AT_TIMESTAMP</code> - the response includes all shards whose start timestamp is less than or
         *        equal to the given timestamp and end timestamp is greater than or equal to the given timestamp or
         *        still open.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FROM_TIMESTAMP</code> - the response incldues all closed shards whose end timestamp is greater
         *        than or equal to the given timestamp and also all open shards. Corrected to <code>TRIM_HORIZON</code>
         *        of the data stream if <code>FROM_TIMESTAMP</code> is less than the <code>TRIM_HORIZON</code> value.
         *        </p>
         *        </li>
         * @see ShardFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShardFilterType
         */
        Builder type(ShardFilterType type);

        /**
         * <p>
         * The exclusive start <code>shardID</code> speified in the <code>ShardFilter</code> parameter. This property
         * can only be used if the <code>AFTER_SHARD_ID</code> shard type is specified.
         * </p>
         * 
         * @param shardId
         *        The exclusive start <code>shardID</code> speified in the <code>ShardFilter</code> parameter. This
         *        property can only be used if the <code>AFTER_SHARD_ID</code> shard type is specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardId(String shardId);

        /**
         * <p>
         * The timestamps specified in the <code>ShardFilter</code> parameter. A timestamp is a Unix epoch date with
         * precision in milliseconds. For example, 2016-04-04T19:58:46.480-00:00 or 1459799926.480. This property can
         * only be used if <code>FROM_TIMESTAMP</code> or <code>AT_TIMESTAMP</code> shard types are specified.
         * </p>
         * 
         * @param timestamp
         *        The timestamps specified in the <code>ShardFilter</code> parameter. A timestamp is a Unix epoch date
         *        with precision in milliseconds. For example, 2016-04-04T19:58:46.480-00:00 or 1459799926.480. This
         *        property can only be used if <code>FROM_TIMESTAMP</code> or <code>AT_TIMESTAMP</code> shard types are
         *        specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String shardId;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ShardFilter model) {
            type(model.type);
            shardId(model.shardId);
            timestamp(model.timestamp);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ShardFilterType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getShardId() {
            return shardId;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public ShardFilter build() {
            return new ShardFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
