/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListShardsRequest extends KinesisRequest implements
        ToCopyableBuilder<ListShardsRequest.Builder, ListShardsRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(ListShardsRequest::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListShardsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> EXCLUSIVE_START_SHARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExclusiveStartShardId").getter(getter(ListShardsRequest::exclusiveStartShardId))
            .setter(setter(Builder::exclusiveStartShardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveStartShardId").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListShardsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<Instant> STREAM_CREATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StreamCreationTimestamp").getter(getter(ListShardsRequest::streamCreationTimestamp))
            .setter(setter(Builder::streamCreationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamCreationTimestamp").build())
            .build();

    private static final SdkField<ShardFilter> SHARD_FILTER_FIELD = SdkField.<ShardFilter> builder(MarshallingType.SDK_POJO)
            .memberName("ShardFilter").getter(getter(ListShardsRequest::shardFilter)).setter(setter(Builder::shardFilter))
            .constructor(ShardFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardFilter").build()).build();

    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(ListShardsRequest::streamARN)).setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD,
            NEXT_TOKEN_FIELD, EXCLUSIVE_START_SHARD_ID_FIELD, MAX_RESULTS_FIELD, STREAM_CREATION_TIMESTAMP_FIELD,
            SHARD_FILTER_FIELD, STREAM_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String streamName;

    private final String nextToken;

    private final String exclusiveStartShardId;

    private final Integer maxResults;

    private final Instant streamCreationTimestamp;

    private final ShardFilter shardFilter;

    private final String streamARN;

    private ListShardsRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.nextToken = builder.nextToken;
        this.exclusiveStartShardId = builder.exclusiveStartShardId;
        this.maxResults = builder.maxResults;
        this.streamCreationTimestamp = builder.streamCreationTimestamp;
        this.shardFilter = builder.shardFilter;
        this.streamARN = builder.streamARN;
    }

    /**
     * <p>
     * The name of the data stream whose shards you want to list.
     * </p>
     * <p>
     * You cannot specify this parameter if you specify the <code>NextToken</code> parameter.
     * </p>
     * 
     * @return The name of the data stream whose shards you want to list. </p>
     *         <p>
     *         You cannot specify this parameter if you specify the <code>NextToken</code> parameter.
     */
    public final String streamName() {
        return streamName;
    }

    /**
     * <p>
     * When the number of shards in the data stream is greater than the default value for the <code>MaxResults</code>
     * parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of
     * shards in the data stream, the response includes a pagination token named <code>NextToken</code>. You can specify
     * this <code>NextToken</code> value in a subsequent call to <code>ListShards</code> to list the next set of shards.
     * </p>
     * <p>
     * Don't specify <code>StreamName</code> or <code>StreamCreationTimestamp</code> if you specify
     * <code>NextToken</code> because the latter unambiguously identifies the stream.
     * </p>
     * <p>
     * You can optionally specify a value for the <code>MaxResults</code> parameter when you specify
     * <code>NextToken</code>. If you specify a <code>MaxResults</code> value that is less than the number of shards
     * that the operation returns if you don't specify <code>MaxResults</code>, the response will contain a new
     * <code>NextToken</code> value. You can use the new <code>NextToken</code> value in a subsequent call to the
     * <code>ListShards</code> operation.
     * </p>
     * <important>
     * <p>
     * Tokens expire after 300 seconds. When you obtain a value for <code>NextToken</code> in the response to a call to
     * <code>ListShards</code>, you have 300 seconds to use that value. If you specify an expired token in a call to
     * <code>ListShards</code>, you get <code>ExpiredNextTokenException</code>.
     * </p>
     * </important>
     * 
     * @return When the number of shards in the data stream is greater than the default value for the
     *         <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that
     *         is less than the number of shards in the data stream, the response includes a pagination token named
     *         <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to
     *         <code>ListShards</code> to list the next set of shards.</p>
     *         <p>
     *         Don't specify <code>StreamName</code> or <code>StreamCreationTimestamp</code> if you specify
     *         <code>NextToken</code> because the latter unambiguously identifies the stream.
     *         </p>
     *         <p>
     *         You can optionally specify a value for the <code>MaxResults</code> parameter when you specify
     *         <code>NextToken</code>. If you specify a <code>MaxResults</code> value that is less than the number of
     *         shards that the operation returns if you don't specify <code>MaxResults</code>, the response will contain
     *         a new <code>NextToken</code> value. You can use the new <code>NextToken</code> value in a subsequent call
     *         to the <code>ListShards</code> operation.
     *         </p>
     *         <important>
     *         <p>
     *         Tokens expire after 300 seconds. When you obtain a value for <code>NextToken</code> in the response to a
     *         call to <code>ListShards</code>, you have 300 seconds to use that value. If you specify an expired token
     *         in a call to <code>ListShards</code>, you get <code>ExpiredNextTokenException</code>.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specify this parameter to indicate that you want to list the shards starting with the shard whose ID immediately
     * follows <code>ExclusiveStartShardId</code>.
     * </p>
     * <p>
     * If you don't specify this parameter, the default behavior is for <code>ListShards</code> to list the shards
     * starting with the first one in the stream.
     * </p>
     * <p>
     * You cannot specify this parameter if you specify <code>NextToken</code>.
     * </p>
     * 
     * @return Specify this parameter to indicate that you want to list the shards starting with the shard whose ID
     *         immediately follows <code>ExclusiveStartShardId</code>.</p>
     *         <p>
     *         If you don't specify this parameter, the default behavior is for <code>ListShards</code> to list the
     *         shards starting with the first one in the stream.
     *         </p>
     *         <p>
     *         You cannot specify this parameter if you specify <code>NextToken</code>.
     */
    public final String exclusiveStartShardId() {
        return exclusiveStartShardId;
    }

    /**
     * <p>
     * The maximum number of shards to return in a single call to <code>ListShards</code>. The maximum number of shards
     * to return in a single call. The default value is 1000. If you specify a value greater than 1000, at most 1000
     * results are returned.
     * </p>
     * <p>
     * When the number of shards to be listed is greater than the value of <code>MaxResults</code>, the response
     * contains a <code>NextToken</code> value that you can use in a subsequent call to <code>ListShards</code> to list
     * the next set of shards.
     * </p>
     * 
     * @return The maximum number of shards to return in a single call to <code>ListShards</code>. The maximum number of
     *         shards to return in a single call. The default value is 1000. If you specify a value greater than 1000,
     *         at most 1000 results are returned. </p>
     *         <p>
     *         When the number of shards to be listed is greater than the value of <code>MaxResults</code>, the response
     *         contains a <code>NextToken</code> value that you can use in a subsequent call to <code>ListShards</code>
     *         to list the next set of shards.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Specify this input parameter to distinguish data streams that have the same name. For example, if you create a
     * data stream and then delete it, and you later create another data stream with the same name, you can use this
     * input parameter to specify which of the two streams you want to list the shards for.
     * </p>
     * <p>
     * You cannot specify this parameter if you specify the <code>NextToken</code> parameter.
     * </p>
     * 
     * @return Specify this input parameter to distinguish data streams that have the same name. For example, if you
     *         create a data stream and then delete it, and you later create another data stream with the same name, you
     *         can use this input parameter to specify which of the two streams you want to list the shards for.</p>
     *         <p>
     *         You cannot specify this parameter if you specify the <code>NextToken</code> parameter.
     */
    public final Instant streamCreationTimestamp() {
        return streamCreationTimestamp;
    }

    /**
     * <p>
     * Enables you to filter out the response of the <code>ListShards</code> API. You can only specify one filter at a
     * time.
     * </p>
     * <p>
     * If you use the <code>ShardFilter</code> parameter when invoking the ListShards API, the <code>Type</code> is the
     * required property and must be specified. If you specify the <code>AT_TRIM_HORIZON</code>,
     * <code>FROM_TRIM_HORIZON</code>, or <code>AT_LATEST</code> types, you do not need to specify either the
     * <code>ShardId</code> or the <code>Timestamp</code> optional properties.
     * </p>
     * <p>
     * If you specify the <code>AFTER_SHARD_ID</code> type, you must also provide the value for the optional
     * <code>ShardId</code> property. The <code>ShardId</code> property is identical in fuctionality to the
     * <code>ExclusiveStartShardId</code> parameter of the <code>ListShards</code> API. When <code>ShardId</code>
     * property is specified, the response includes the shards starting with the shard whose ID immediately follows the
     * <code>ShardId</code> that you provided.
     * </p>
     * <p>
     * If you specify the <code>AT_TIMESTAMP</code> or <code>FROM_TIMESTAMP_ID</code> type, you must also provide the
     * value for the optional <code>Timestamp</code> property. If you specify the AT_TIMESTAMP type, then all shards
     * that were open at the provided timestamp are returned. If you specify the FROM_TIMESTAMP type, then all shards
     * starting from the provided timestamp to TIP are returned.
     * </p>
     * 
     * @return Enables you to filter out the response of the <code>ListShards</code> API. You can only specify one
     *         filter at a time. </p>
     *         <p>
     *         If you use the <code>ShardFilter</code> parameter when invoking the ListShards API, the <code>Type</code>
     *         is the required property and must be specified. If you specify the <code>AT_TRIM_HORIZON</code>,
     *         <code>FROM_TRIM_HORIZON</code>, or <code>AT_LATEST</code> types, you do not need to specify either the
     *         <code>ShardId</code> or the <code>Timestamp</code> optional properties.
     *         </p>
     *         <p>
     *         If you specify the <code>AFTER_SHARD_ID</code> type, you must also provide the value for the optional
     *         <code>ShardId</code> property. The <code>ShardId</code> property is identical in fuctionality to the
     *         <code>ExclusiveStartShardId</code> parameter of the <code>ListShards</code> API. When
     *         <code>ShardId</code> property is specified, the response includes the shards starting with the shard
     *         whose ID immediately follows the <code>ShardId</code> that you provided.
     *         </p>
     *         <p>
     *         If you specify the <code>AT_TIMESTAMP</code> or <code>FROM_TIMESTAMP_ID</code> type, you must also
     *         provide the value for the optional <code>Timestamp</code> property. If you specify the AT_TIMESTAMP type,
     *         then all shards that were open at the provided timestamp are returned. If you specify the FROM_TIMESTAMP
     *         type, then all shards starting from the provided timestamp to TIP are returned.
     */
    public final ShardFilter shardFilter() {
        return shardFilter;
    }

    /**
     * <p>
     * The ARN of the stream.
     * </p>
     * 
     * @return The ARN of the stream.
     */
    public final String streamARN() {
        return streamARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(exclusiveStartShardId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(streamCreationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(shardFilter());
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListShardsRequest)) {
            return false;
        }
        ListShardsRequest other = (ListShardsRequest) obj;
        return Objects.equals(streamName(), other.streamName()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(exclusiveStartShardId(), other.exclusiveStartShardId())
                && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(streamCreationTimestamp(), other.streamCreationTimestamp())
                && Objects.equals(shardFilter(), other.shardFilter()) && Objects.equals(streamARN(), other.streamARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListShardsRequest").add("StreamName", streamName()).add("NextToken", nextToken())
                .add("ExclusiveStartShardId", exclusiveStartShardId()).add("MaxResults", maxResults())
                .add("StreamCreationTimestamp", streamCreationTimestamp()).add("ShardFilter", shardFilter())
                .add("StreamARN", streamARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ExclusiveStartShardId":
            return Optional.ofNullable(clazz.cast(exclusiveStartShardId()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "StreamCreationTimestamp":
            return Optional.ofNullable(clazz.cast(streamCreationTimestamp()));
        case "ShardFilter":
            return Optional.ofNullable(clazz.cast(shardFilter()));
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StreamName", STREAM_NAME_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ExclusiveStartShardId", EXCLUSIVE_START_SHARD_ID_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("StreamCreationTimestamp", STREAM_CREATION_TIMESTAMP_FIELD);
        map.put("ShardFilter", SHARD_FILTER_FIELD);
        map.put("StreamARN", STREAM_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListShardsRequest, T> g) {
        return obj -> g.apply((ListShardsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KinesisRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListShardsRequest> {
        /**
         * <p>
         * The name of the data stream whose shards you want to list.
         * </p>
         * <p>
         * You cannot specify this parameter if you specify the <code>NextToken</code> parameter.
         * </p>
         * 
         * @param streamName
         *        The name of the data stream whose shards you want to list. </p>
         *        <p>
         *        You cannot specify this parameter if you specify the <code>NextToken</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * When the number of shards in the data stream is greater than the default value for the
         * <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is
         * less than the number of shards in the data stream, the response includes a pagination token named
         * <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to
         * <code>ListShards</code> to list the next set of shards.
         * </p>
         * <p>
         * Don't specify <code>StreamName</code> or <code>StreamCreationTimestamp</code> if you specify
         * <code>NextToken</code> because the latter unambiguously identifies the stream.
         * </p>
         * <p>
         * You can optionally specify a value for the <code>MaxResults</code> parameter when you specify
         * <code>NextToken</code>. If you specify a <code>MaxResults</code> value that is less than the number of shards
         * that the operation returns if you don't specify <code>MaxResults</code>, the response will contain a new
         * <code>NextToken</code> value. You can use the new <code>NextToken</code> value in a subsequent call to the
         * <code>ListShards</code> operation.
         * </p>
         * <important>
         * <p>
         * Tokens expire after 300 seconds. When you obtain a value for <code>NextToken</code> in the response to a call
         * to <code>ListShards</code>, you have 300 seconds to use that value. If you specify an expired token in a call
         * to <code>ListShards</code>, you get <code>ExpiredNextTokenException</code>.
         * </p>
         * </important>
         * 
         * @param nextToken
         *        When the number of shards in the data stream is greater than the default value for the
         *        <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code>
         *        that is less than the number of shards in the data stream, the response includes a pagination token
         *        named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call
         *        to <code>ListShards</code> to list the next set of shards.</p>
         *        <p>
         *        Don't specify <code>StreamName</code> or <code>StreamCreationTimestamp</code> if you specify
         *        <code>NextToken</code> because the latter unambiguously identifies the stream.
         *        </p>
         *        <p>
         *        You can optionally specify a value for the <code>MaxResults</code> parameter when you specify
         *        <code>NextToken</code>. If you specify a <code>MaxResults</code> value that is less than the number of
         *        shards that the operation returns if you don't specify <code>MaxResults</code>, the response will
         *        contain a new <code>NextToken</code> value. You can use the new <code>NextToken</code> value in a
         *        subsequent call to the <code>ListShards</code> operation.
         *        </p>
         *        <important>
         *        <p>
         *        Tokens expire after 300 seconds. When you obtain a value for <code>NextToken</code> in the response to
         *        a call to <code>ListShards</code>, you have 300 seconds to use that value. If you specify an expired
         *        token in a call to <code>ListShards</code>, you get <code>ExpiredNextTokenException</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specify this parameter to indicate that you want to list the shards starting with the shard whose ID
         * immediately follows <code>ExclusiveStartShardId</code>.
         * </p>
         * <p>
         * If you don't specify this parameter, the default behavior is for <code>ListShards</code> to list the shards
         * starting with the first one in the stream.
         * </p>
         * <p>
         * You cannot specify this parameter if you specify <code>NextToken</code>.
         * </p>
         * 
         * @param exclusiveStartShardId
         *        Specify this parameter to indicate that you want to list the shards starting with the shard whose ID
         *        immediately follows <code>ExclusiveStartShardId</code>.</p>
         *        <p>
         *        If you don't specify this parameter, the default behavior is for <code>ListShards</code> to list the
         *        shards starting with the first one in the stream.
         *        </p>
         *        <p>
         *        You cannot specify this parameter if you specify <code>NextToken</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartShardId(String exclusiveStartShardId);

        /**
         * <p>
         * The maximum number of shards to return in a single call to <code>ListShards</code>. The maximum number of
         * shards to return in a single call. The default value is 1000. If you specify a value greater than 1000, at
         * most 1000 results are returned.
         * </p>
         * <p>
         * When the number of shards to be listed is greater than the value of <code>MaxResults</code>, the response
         * contains a <code>NextToken</code> value that you can use in a subsequent call to <code>ListShards</code> to
         * list the next set of shards.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of shards to return in a single call to <code>ListShards</code>. The maximum number
         *        of shards to return in a single call. The default value is 1000. If you specify a value greater than
         *        1000, at most 1000 results are returned. </p>
         *        <p>
         *        When the number of shards to be listed is greater than the value of <code>MaxResults</code>, the
         *        response contains a <code>NextToken</code> value that you can use in a subsequent call to
         *        <code>ListShards</code> to list the next set of shards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Specify this input parameter to distinguish data streams that have the same name. For example, if you create
         * a data stream and then delete it, and you later create another data stream with the same name, you can use
         * this input parameter to specify which of the two streams you want to list the shards for.
         * </p>
         * <p>
         * You cannot specify this parameter if you specify the <code>NextToken</code> parameter.
         * </p>
         * 
         * @param streamCreationTimestamp
         *        Specify this input parameter to distinguish data streams that have the same name. For example, if you
         *        create a data stream and then delete it, and you later create another data stream with the same name,
         *        you can use this input parameter to specify which of the two streams you want to list the shards
         *        for.</p>
         *        <p>
         *        You cannot specify this parameter if you specify the <code>NextToken</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamCreationTimestamp(Instant streamCreationTimestamp);

        /**
         * <p>
         * Enables you to filter out the response of the <code>ListShards</code> API. You can only specify one filter at
         * a time.
         * </p>
         * <p>
         * If you use the <code>ShardFilter</code> parameter when invoking the ListShards API, the <code>Type</code> is
         * the required property and must be specified. If you specify the <code>AT_TRIM_HORIZON</code>,
         * <code>FROM_TRIM_HORIZON</code>, or <code>AT_LATEST</code> types, you do not need to specify either the
         * <code>ShardId</code> or the <code>Timestamp</code> optional properties.
         * </p>
         * <p>
         * If you specify the <code>AFTER_SHARD_ID</code> type, you must also provide the value for the optional
         * <code>ShardId</code> property. The <code>ShardId</code> property is identical in fuctionality to the
         * <code>ExclusiveStartShardId</code> parameter of the <code>ListShards</code> API. When <code>ShardId</code>
         * property is specified, the response includes the shards starting with the shard whose ID immediately follows
         * the <code>ShardId</code> that you provided.
         * </p>
         * <p>
         * If you specify the <code>AT_TIMESTAMP</code> or <code>FROM_TIMESTAMP_ID</code> type, you must also provide
         * the value for the optional <code>Timestamp</code> property. If you specify the AT_TIMESTAMP type, then all
         * shards that were open at the provided timestamp are returned. If you specify the FROM_TIMESTAMP type, then
         * all shards starting from the provided timestamp to TIP are returned.
         * </p>
         * 
         * @param shardFilter
         *        Enables you to filter out the response of the <code>ListShards</code> API. You can only specify one
         *        filter at a time. </p>
         *        <p>
         *        If you use the <code>ShardFilter</code> parameter when invoking the ListShards API, the
         *        <code>Type</code> is the required property and must be specified. If you specify the
         *        <code>AT_TRIM_HORIZON</code>, <code>FROM_TRIM_HORIZON</code>, or <code>AT_LATEST</code> types, you do
         *        not need to specify either the <code>ShardId</code> or the <code>Timestamp</code> optional properties.
         *        </p>
         *        <p>
         *        If you specify the <code>AFTER_SHARD_ID</code> type, you must also provide the value for the optional
         *        <code>ShardId</code> property. The <code>ShardId</code> property is identical in fuctionality to the
         *        <code>ExclusiveStartShardId</code> parameter of the <code>ListShards</code> API. When
         *        <code>ShardId</code> property is specified, the response includes the shards starting with the shard
         *        whose ID immediately follows the <code>ShardId</code> that you provided.
         *        </p>
         *        <p>
         *        If you specify the <code>AT_TIMESTAMP</code> or <code>FROM_TIMESTAMP_ID</code> type, you must also
         *        provide the value for the optional <code>Timestamp</code> property. If you specify the AT_TIMESTAMP
         *        type, then all shards that were open at the provided timestamp are returned. If you specify the
         *        FROM_TIMESTAMP type, then all shards starting from the provided timestamp to TIP are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardFilter(ShardFilter shardFilter);

        /**
         * <p>
         * Enables you to filter out the response of the <code>ListShards</code> API. You can only specify one filter at
         * a time.
         * </p>
         * <p>
         * If you use the <code>ShardFilter</code> parameter when invoking the ListShards API, the <code>Type</code> is
         * the required property and must be specified. If you specify the <code>AT_TRIM_HORIZON</code>,
         * <code>FROM_TRIM_HORIZON</code>, or <code>AT_LATEST</code> types, you do not need to specify either the
         * <code>ShardId</code> or the <code>Timestamp</code> optional properties.
         * </p>
         * <p>
         * If you specify the <code>AFTER_SHARD_ID</code> type, you must also provide the value for the optional
         * <code>ShardId</code> property. The <code>ShardId</code> property is identical in fuctionality to the
         * <code>ExclusiveStartShardId</code> parameter of the <code>ListShards</code> API. When <code>ShardId</code>
         * property is specified, the response includes the shards starting with the shard whose ID immediately follows
         * the <code>ShardId</code> that you provided.
         * </p>
         * <p>
         * If you specify the <code>AT_TIMESTAMP</code> or <code>FROM_TIMESTAMP_ID</code> type, you must also provide
         * the value for the optional <code>Timestamp</code> property. If you specify the AT_TIMESTAMP type, then all
         * shards that were open at the provided timestamp are returned. If you specify the FROM_TIMESTAMP type, then
         * all shards starting from the provided timestamp to TIP are returned.
         * </p>
         * This is a convenience method that creates an instance of the {@link ShardFilter.Builder} avoiding the need to
         * create one manually via {@link ShardFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ShardFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #shardFilter(ShardFilter)}.
         * 
         * @param shardFilter
         *        a consumer that will call methods on {@link ShardFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shardFilter(ShardFilter)
         */
        default Builder shardFilter(Consumer<ShardFilter.Builder> shardFilter) {
            return shardFilter(ShardFilter.builder().applyMutation(shardFilter).build());
        }

        /**
         * <p>
         * The ARN of the stream.
         * </p>
         * 
         * @param streamARN
         *        The ARN of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisRequest.BuilderImpl implements Builder {
        private String streamName;

        private String nextToken;

        private String exclusiveStartShardId;

        private Integer maxResults;

        private Instant streamCreationTimestamp;

        private ShardFilter shardFilter;

        private String streamARN;

        private BuilderImpl() {
        }

        private BuilderImpl(ListShardsRequest model) {
            super(model);
            streamName(model.streamName);
            nextToken(model.nextToken);
            exclusiveStartShardId(model.exclusiveStartShardId);
            maxResults(model.maxResults);
            streamCreationTimestamp(model.streamCreationTimestamp);
            shardFilter(model.shardFilter);
            streamARN(model.streamARN);
        }

        public final String getStreamName() {
            return streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getExclusiveStartShardId() {
            return exclusiveStartShardId;
        }

        public final void setExclusiveStartShardId(String exclusiveStartShardId) {
            this.exclusiveStartShardId = exclusiveStartShardId;
        }

        @Override
        public final Builder exclusiveStartShardId(String exclusiveStartShardId) {
            this.exclusiveStartShardId = exclusiveStartShardId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Instant getStreamCreationTimestamp() {
            return streamCreationTimestamp;
        }

        public final void setStreamCreationTimestamp(Instant streamCreationTimestamp) {
            this.streamCreationTimestamp = streamCreationTimestamp;
        }

        @Override
        public final Builder streamCreationTimestamp(Instant streamCreationTimestamp) {
            this.streamCreationTimestamp = streamCreationTimestamp;
            return this;
        }

        public final ShardFilter.Builder getShardFilter() {
            return shardFilter != null ? shardFilter.toBuilder() : null;
        }

        public final void setShardFilter(ShardFilter.BuilderImpl shardFilter) {
            this.shardFilter = shardFilter != null ? shardFilter.build() : null;
        }

        @Override
        public final Builder shardFilter(ShardFilter shardFilter) {
            this.shardFilter = shardFilter;
            return this;
        }

        public final String getStreamARN() {
            return streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListShardsRequest build() {
            return new ListShardsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
