/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLimitsResponse extends KinesisResponse implements
        ToCopyableBuilder<DescribeLimitsResponse.Builder, DescribeLimitsResponse> {
    private static final SdkField<Integer> SHARD_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ShardLimit").getter(getter(DescribeLimitsResponse::shardLimit)).setter(setter(Builder::shardLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardLimit").build()).build();

    private static final SdkField<Integer> OPEN_SHARD_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("OpenShardCount").getter(getter(DescribeLimitsResponse::openShardCount))
            .setter(setter(Builder::openShardCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenShardCount").build()).build();

    private static final SdkField<Integer> ON_DEMAND_STREAM_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("OnDemandStreamCount").getter(getter(DescribeLimitsResponse::onDemandStreamCount))
            .setter(setter(Builder::onDemandStreamCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandStreamCount").build())
            .build();

    private static final SdkField<Integer> ON_DEMAND_STREAM_COUNT_LIMIT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("OnDemandStreamCountLimit")
            .getter(getter(DescribeLimitsResponse::onDemandStreamCountLimit)).setter(setter(Builder::onDemandStreamCountLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandStreamCountLimit").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARD_LIMIT_FIELD,
            OPEN_SHARD_COUNT_FIELD, ON_DEMAND_STREAM_COUNT_FIELD, ON_DEMAND_STREAM_COUNT_LIMIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer shardLimit;

    private final Integer openShardCount;

    private final Integer onDemandStreamCount;

    private final Integer onDemandStreamCountLimit;

    private DescribeLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.shardLimit = builder.shardLimit;
        this.openShardCount = builder.openShardCount;
        this.onDemandStreamCount = builder.onDemandStreamCount;
        this.onDemandStreamCountLimit = builder.onDemandStreamCountLimit;
    }

    /**
     * <p>
     * The maximum number of shards.
     * </p>
     * 
     * @return The maximum number of shards.
     */
    public final Integer shardLimit() {
        return shardLimit;
    }

    /**
     * <p>
     * The number of open shards.
     * </p>
     * 
     * @return The number of open shards.
     */
    public final Integer openShardCount() {
        return openShardCount;
    }

    /**
     * <p>
     * Indicates the number of data streams with the on-demand capacity mode.
     * </p>
     * 
     * @return Indicates the number of data streams with the on-demand capacity mode.
     */
    public final Integer onDemandStreamCount() {
        return onDemandStreamCount;
    }

    /**
     * <p>
     * The maximum number of data streams with the on-demand capacity mode.
     * </p>
     * 
     * @return The maximum number of data streams with the on-demand capacity mode.
     */
    public final Integer onDemandStreamCountLimit() {
        return onDemandStreamCountLimit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(shardLimit());
        hashCode = 31 * hashCode + Objects.hashCode(openShardCount());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandStreamCount());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandStreamCountLimit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLimitsResponse)) {
            return false;
        }
        DescribeLimitsResponse other = (DescribeLimitsResponse) obj;
        return Objects.equals(shardLimit(), other.shardLimit()) && Objects.equals(openShardCount(), other.openShardCount())
                && Objects.equals(onDemandStreamCount(), other.onDemandStreamCount())
                && Objects.equals(onDemandStreamCountLimit(), other.onDemandStreamCountLimit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLimitsResponse").add("ShardLimit", shardLimit()).add("OpenShardCount", openShardCount())
                .add("OnDemandStreamCount", onDemandStreamCount()).add("OnDemandStreamCountLimit", onDemandStreamCountLimit())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShardLimit":
            return Optional.ofNullable(clazz.cast(shardLimit()));
        case "OpenShardCount":
            return Optional.ofNullable(clazz.cast(openShardCount()));
        case "OnDemandStreamCount":
            return Optional.ofNullable(clazz.cast(onDemandStreamCount()));
        case "OnDemandStreamCountLimit":
            return Optional.ofNullable(clazz.cast(onDemandStreamCountLimit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ShardLimit", SHARD_LIMIT_FIELD);
        map.put("OpenShardCount", OPEN_SHARD_COUNT_FIELD);
        map.put("OnDemandStreamCount", ON_DEMAND_STREAM_COUNT_FIELD);
        map.put("OnDemandStreamCountLimit", ON_DEMAND_STREAM_COUNT_LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeLimitsResponse, T> g) {
        return obj -> g.apply((DescribeLimitsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KinesisResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLimitsResponse> {
        /**
         * <p>
         * The maximum number of shards.
         * </p>
         * 
         * @param shardLimit
         *        The maximum number of shards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardLimit(Integer shardLimit);

        /**
         * <p>
         * The number of open shards.
         * </p>
         * 
         * @param openShardCount
         *        The number of open shards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openShardCount(Integer openShardCount);

        /**
         * <p>
         * Indicates the number of data streams with the on-demand capacity mode.
         * </p>
         * 
         * @param onDemandStreamCount
         *        Indicates the number of data streams with the on-demand capacity mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandStreamCount(Integer onDemandStreamCount);

        /**
         * <p>
         * The maximum number of data streams with the on-demand capacity mode.
         * </p>
         * 
         * @param onDemandStreamCountLimit
         *        The maximum number of data streams with the on-demand capacity mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandStreamCountLimit(Integer onDemandStreamCountLimit);
    }

    static final class BuilderImpl extends KinesisResponse.BuilderImpl implements Builder {
        private Integer shardLimit;

        private Integer openShardCount;

        private Integer onDemandStreamCount;

        private Integer onDemandStreamCountLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLimitsResponse model) {
            super(model);
            shardLimit(model.shardLimit);
            openShardCount(model.openShardCount);
            onDemandStreamCount(model.onDemandStreamCount);
            onDemandStreamCountLimit(model.onDemandStreamCountLimit);
        }

        public final Integer getShardLimit() {
            return shardLimit;
        }

        public final void setShardLimit(Integer shardLimit) {
            this.shardLimit = shardLimit;
        }

        @Override
        public final Builder shardLimit(Integer shardLimit) {
            this.shardLimit = shardLimit;
            return this;
        }

        public final Integer getOpenShardCount() {
            return openShardCount;
        }

        public final void setOpenShardCount(Integer openShardCount) {
            this.openShardCount = openShardCount;
        }

        @Override
        public final Builder openShardCount(Integer openShardCount) {
            this.openShardCount = openShardCount;
            return this;
        }

        public final Integer getOnDemandStreamCount() {
            return onDemandStreamCount;
        }

        public final void setOnDemandStreamCount(Integer onDemandStreamCount) {
            this.onDemandStreamCount = onDemandStreamCount;
        }

        @Override
        public final Builder onDemandStreamCount(Integer onDemandStreamCount) {
            this.onDemandStreamCount = onDemandStreamCount;
            return this;
        }

        public final Integer getOnDemandStreamCountLimit() {
            return onDemandStreamCountLimit;
        }

        public final void setOnDemandStreamCountLimit(Integer onDemandStreamCountLimit) {
            this.onDemandStreamCountLimit = onDemandStreamCountLimit;
        }

        @Override
        public final Builder onDemandStreamCountLimit(Integer onDemandStreamCountLimit) {
            this.onDemandStreamCountLimit = onDemandStreamCountLimit;
            return this;
        }

        @Override
        public DescribeLimitsResponse build() {
            return new DescribeLimitsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
