/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.cbor.AwsCborProtocolFactory;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.KinesisServiceClientConfiguration;
import software.amazon.awssdk.services.kinesis.internal.KinesisServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.kinesis.model.AccessDeniedException;
import software.amazon.awssdk.services.kinesis.model.AddTagsToStreamRequest;
import software.amazon.awssdk.services.kinesis.model.AddTagsToStreamResponse;
import software.amazon.awssdk.services.kinesis.model.CreateStreamRequest;
import software.amazon.awssdk.services.kinesis.model.CreateStreamResponse;
import software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodRequest;
import software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodResponse;
import software.amazon.awssdk.services.kinesis.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.kinesis.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.kinesis.model.DeleteStreamRequest;
import software.amazon.awssdk.services.kinesis.model.DeleteStreamResponse;
import software.amazon.awssdk.services.kinesis.model.DeregisterStreamConsumerRequest;
import software.amazon.awssdk.services.kinesis.model.DeregisterStreamConsumerResponse;
import software.amazon.awssdk.services.kinesis.model.DescribeLimitsRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeLimitsResponse;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerResponse;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryResponse;
import software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringRequest;
import software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringResponse;
import software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringRequest;
import software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringResponse;
import software.amazon.awssdk.services.kinesis.model.ExpiredIteratorException;
import software.amazon.awssdk.services.kinesis.model.ExpiredNextTokenException;
import software.amazon.awssdk.services.kinesis.model.GetRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.GetRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.kinesis.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodRequest;
import software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodResponse;
import software.amazon.awssdk.services.kinesis.model.InternalFailureException;
import software.amazon.awssdk.services.kinesis.model.InvalidArgumentException;
import software.amazon.awssdk.services.kinesis.model.KinesisException;
import software.amazon.awssdk.services.kinesis.model.KmsAccessDeniedException;
import software.amazon.awssdk.services.kinesis.model.KmsDisabledException;
import software.amazon.awssdk.services.kinesis.model.KmsInvalidStateException;
import software.amazon.awssdk.services.kinesis.model.KmsNotFoundException;
import software.amazon.awssdk.services.kinesis.model.KmsOptInRequiredException;
import software.amazon.awssdk.services.kinesis.model.KmsThrottlingException;
import software.amazon.awssdk.services.kinesis.model.LimitExceededException;
import software.amazon.awssdk.services.kinesis.model.ListShardsRequest;
import software.amazon.awssdk.services.kinesis.model.ListShardsResponse;
import software.amazon.awssdk.services.kinesis.model.ListStreamConsumersRequest;
import software.amazon.awssdk.services.kinesis.model.ListStreamConsumersResponse;
import software.amazon.awssdk.services.kinesis.model.ListStreamsRequest;
import software.amazon.awssdk.services.kinesis.model.ListStreamsResponse;
import software.amazon.awssdk.services.kinesis.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.kinesis.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.kinesis.model.ListTagsForStreamRequest;
import software.amazon.awssdk.services.kinesis.model.ListTagsForStreamResponse;
import software.amazon.awssdk.services.kinesis.model.MergeShardsRequest;
import software.amazon.awssdk.services.kinesis.model.MergeShardsResponse;
import software.amazon.awssdk.services.kinesis.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.kinesis.model.PutRecordRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordResponse;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.kinesis.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerRequest;
import software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerResponse;
import software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamRequest;
import software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamResponse;
import software.amazon.awssdk.services.kinesis.model.ResourceInUseException;
import software.amazon.awssdk.services.kinesis.model.ResourceNotFoundException;
import software.amazon.awssdk.services.kinesis.model.SplitShardRequest;
import software.amazon.awssdk.services.kinesis.model.SplitShardResponse;
import software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionRequest;
import software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionResponse;
import software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionRequest;
import software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionResponse;
import software.amazon.awssdk.services.kinesis.model.TagResourceRequest;
import software.amazon.awssdk.services.kinesis.model.TagResourceResponse;
import software.amazon.awssdk.services.kinesis.model.UntagResourceRequest;
import software.amazon.awssdk.services.kinesis.model.UntagResourceResponse;
import software.amazon.awssdk.services.kinesis.model.UpdateShardCountRequest;
import software.amazon.awssdk.services.kinesis.model.UpdateShardCountResponse;
import software.amazon.awssdk.services.kinesis.model.UpdateStreamModeRequest;
import software.amazon.awssdk.services.kinesis.model.UpdateStreamModeResponse;
import software.amazon.awssdk.services.kinesis.model.ValidationException;
import software.amazon.awssdk.services.kinesis.transform.AddTagsToStreamRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.CreateStreamRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.DecreaseStreamRetentionPeriodRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.DeleteStreamRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.DeregisterStreamConsumerRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.DescribeLimitsRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.DescribeStreamConsumerRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.DescribeStreamRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.DescribeStreamSummaryRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.DisableEnhancedMonitoringRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.EnableEnhancedMonitoringRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.GetRecordsRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.GetResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.GetShardIteratorRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.IncreaseStreamRetentionPeriodRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.ListShardsRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.ListStreamConsumersRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.ListStreamsRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.ListTagsForStreamRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.MergeShardsRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.PutRecordRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.PutRecordsRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.RegisterStreamConsumerRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.RemoveTagsFromStreamRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.SplitShardRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.StartStreamEncryptionRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.StopStreamEncryptionRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.UpdateShardCountRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.UpdateStreamModeRequestMarshaller;
import software.amazon.awssdk.services.kinesis.waiters.KinesisWaiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultKinesisClient
implements KinesisClient {
    private static final Logger log = Logger.loggerFor(DefaultKinesisClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.CBOR).build();
    private final SyncClientHandler clientHandler;
    private final AwsCborProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultKinesisClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Kinesis#2.36.x").build();
        this.protocolFactory = this.init(AwsCborProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddTagsToStreamResponse addTagsToStream(AddTagsToStreamRequest addTagsToStreamRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddTagsToStreamResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addTagsToStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, addTagsToStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddTagsToStream");
            AddTagsToStreamResponse addTagsToStreamResponse = (AddTagsToStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTagsToStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)addTagsToStreamRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddTagsToStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addTagsToStreamResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$addTagsToStream$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateStreamResponse createStream(CreateStreamRequest createStreamRequest) throws ResourceInUseException, LimitExceededException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateStreamResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, createStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateStream");
            CreateStreamResponse createStreamResponse = (CreateStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createStreamRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createStreamResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$createStream$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DecreaseStreamRetentionPeriodResponse decreaseStreamRetentionPeriod(DecreaseStreamRetentionPeriodRequest decreaseStreamRetentionPeriodRequest) throws ResourceInUseException, ResourceNotFoundException, LimitExceededException, InvalidArgumentException, AccessDeniedException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DecreaseStreamRetentionPeriodResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)decreaseStreamRetentionPeriodRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, decreaseStreamRetentionPeriodRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DecreaseStreamRetentionPeriod");
            DecreaseStreamRetentionPeriodResponse decreaseStreamRetentionPeriodResponse = (DecreaseStreamRetentionPeriodResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DecreaseStreamRetentionPeriod").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)decreaseStreamRetentionPeriodRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DecreaseStreamRetentionPeriodRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return decreaseStreamRetentionPeriodResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$decreaseStreamRetentionPeriod$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest) throws AccessDeniedException, ResourceNotFoundException, LimitExceededException, InvalidArgumentException, ResourceInUseException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourcePolicy");
            DeleteResourcePolicyResponse deleteResourcePolicyResponse = (DeleteResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$deleteResourcePolicy$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteStreamResponse deleteStream(DeleteStreamRequest deleteStreamRequest) throws ResourceNotFoundException, LimitExceededException, ResourceInUseException, InvalidArgumentException, AccessDeniedException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteStreamResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, deleteStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteStream");
            DeleteStreamResponse deleteStreamResponse = (DeleteStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteStreamRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteStreamResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$deleteStream$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterStreamConsumerResponse deregisterStreamConsumer(DeregisterStreamConsumerRequest deregisterStreamConsumerRequest) throws LimitExceededException, ResourceNotFoundException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterStreamConsumerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deregisterStreamConsumerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, deregisterStreamConsumerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterStreamConsumer");
            DeregisterStreamConsumerResponse deregisterStreamConsumerResponse = (DeregisterStreamConsumerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterStreamConsumer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deregisterStreamConsumerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeregisterStreamConsumerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deregisterStreamConsumerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$deregisterStreamConsumer$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLimitsResponse describeLimits(DescribeLimitsRequest describeLimitsRequest) throws LimitExceededException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLimitsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeLimitsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, describeLimitsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLimits");
            DescribeLimitsResponse describeLimitsResponse = (DescribeLimitsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLimits").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeLimitsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLimitsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeLimitsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$describeLimits$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStreamResponse describeStream(DescribeStreamRequest describeStreamRequest) throws ResourceNotFoundException, LimitExceededException, InvalidArgumentException, AccessDeniedException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStreamResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, describeStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeStream");
            DescribeStreamResponse describeStreamResponse = (DescribeStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeStreamRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeStreamResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$describeStream$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStreamConsumerResponse describeStreamConsumer(DescribeStreamConsumerRequest describeStreamConsumerRequest) throws LimitExceededException, ResourceNotFoundException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStreamConsumerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeStreamConsumerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, describeStreamConsumerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeStreamConsumer");
            DescribeStreamConsumerResponse describeStreamConsumerResponse = (DescribeStreamConsumerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStreamConsumer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeStreamConsumerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeStreamConsumerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeStreamConsumerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$describeStreamConsumer$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStreamSummaryResponse describeStreamSummary(DescribeStreamSummaryRequest describeStreamSummaryRequest) throws ResourceNotFoundException, LimitExceededException, InvalidArgumentException, AccessDeniedException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStreamSummaryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeStreamSummaryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, describeStreamSummaryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeStreamSummary");
            DescribeStreamSummaryResponse describeStreamSummaryResponse = (DescribeStreamSummaryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStreamSummary").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeStreamSummaryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeStreamSummaryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeStreamSummaryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$describeStreamSummary$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableEnhancedMonitoringResponse disableEnhancedMonitoring(DisableEnhancedMonitoringRequest disableEnhancedMonitoringRequest) throws InvalidArgumentException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableEnhancedMonitoringResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableEnhancedMonitoringRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, disableEnhancedMonitoringRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableEnhancedMonitoring");
            DisableEnhancedMonitoringResponse disableEnhancedMonitoringResponse = (DisableEnhancedMonitoringResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableEnhancedMonitoring").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disableEnhancedMonitoringRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableEnhancedMonitoringRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableEnhancedMonitoringResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$disableEnhancedMonitoring$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableEnhancedMonitoringResponse enableEnhancedMonitoring(EnableEnhancedMonitoringRequest enableEnhancedMonitoringRequest) throws InvalidArgumentException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableEnhancedMonitoringResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableEnhancedMonitoringRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, enableEnhancedMonitoringRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableEnhancedMonitoring");
            EnableEnhancedMonitoringResponse enableEnhancedMonitoringResponse = (EnableEnhancedMonitoringResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableEnhancedMonitoring").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)enableEnhancedMonitoringRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableEnhancedMonitoringRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableEnhancedMonitoringResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$enableEnhancedMonitoring$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRecordsResponse getRecords(GetRecordsRequest getRecordsRequest) throws ResourceNotFoundException, InvalidArgumentException, ProvisionedThroughputExceededException, ExpiredIteratorException, KmsDisabledException, KmsInvalidStateException, KmsAccessDeniedException, KmsNotFoundException, KmsOptInRequiredException, KmsThrottlingException, AccessDeniedException, InternalFailureException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRecordsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRecordsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, getRecordsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRecords");
            GetRecordsResponse getRecordsResponse = (GetRecordsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRecords").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getRecordsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRecordsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRecordsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$getRecords$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourcePolicyResponse getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) throws AccessDeniedException, ResourceNotFoundException, LimitExceededException, InvalidArgumentException, ResourceInUseException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, getResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourcePolicy");
            GetResourcePolicyResponse getResourcePolicyResponse = (GetResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$getResourcePolicy$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetShardIteratorResponse getShardIterator(GetShardIteratorRequest getShardIteratorRequest) throws ResourceNotFoundException, InvalidArgumentException, ProvisionedThroughputExceededException, AccessDeniedException, InternalFailureException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetShardIteratorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getShardIteratorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, getShardIteratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetShardIterator");
            GetShardIteratorResponse getShardIteratorResponse = (GetShardIteratorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetShardIterator").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getShardIteratorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetShardIteratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getShardIteratorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$getShardIterator$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IncreaseStreamRetentionPeriodResponse increaseStreamRetentionPeriod(IncreaseStreamRetentionPeriodRequest increaseStreamRetentionPeriodRequest) throws ResourceInUseException, ResourceNotFoundException, LimitExceededException, InvalidArgumentException, AccessDeniedException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, IncreaseStreamRetentionPeriodResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)increaseStreamRetentionPeriodRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, increaseStreamRetentionPeriodRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"IncreaseStreamRetentionPeriod");
            IncreaseStreamRetentionPeriodResponse increaseStreamRetentionPeriodResponse = (IncreaseStreamRetentionPeriodResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("IncreaseStreamRetentionPeriod").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)increaseStreamRetentionPeriodRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new IncreaseStreamRetentionPeriodRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return increaseStreamRetentionPeriodResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$increaseStreamRetentionPeriod$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListShardsResponse listShards(ListShardsRequest listShardsRequest) throws ResourceNotFoundException, InvalidArgumentException, LimitExceededException, ExpiredNextTokenException, ResourceInUseException, AccessDeniedException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListShardsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listShardsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, listShardsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListShards");
            ListShardsResponse listShardsResponse = (ListShardsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListShards").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listShardsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListShardsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listShardsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$listShards$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListStreamConsumersResponse listStreamConsumers(ListStreamConsumersRequest listStreamConsumersRequest) throws ResourceNotFoundException, InvalidArgumentException, LimitExceededException, ExpiredNextTokenException, ResourceInUseException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListStreamConsumersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listStreamConsumersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, listStreamConsumersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListStreamConsumers");
            ListStreamConsumersResponse listStreamConsumersResponse = (ListStreamConsumersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStreamConsumers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listStreamConsumersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListStreamConsumersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listStreamConsumersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$listStreamConsumers$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListStreamsResponse listStreams(ListStreamsRequest listStreamsRequest) throws LimitExceededException, ExpiredNextTokenException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListStreamsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listStreamsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, listStreamsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListStreams");
            ListStreamsResponse listStreamsResponse = (ListStreamsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStreams").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listStreamsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListStreamsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listStreamsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$listStreams$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$listTagsForResource$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForStreamResponse listTagsForStream(ListTagsForStreamRequest listTagsForStreamRequest) throws ResourceNotFoundException, InvalidArgumentException, LimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForStreamResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, listTagsForStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForStream");
            ListTagsForStreamResponse listTagsForStreamResponse = (ListTagsForStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForStreamRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForStreamResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$listTagsForStream$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MergeShardsResponse mergeShards(MergeShardsRequest mergeShardsRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, MergeShardsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)mergeShardsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, mergeShardsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"MergeShards");
            MergeShardsResponse mergeShardsResponse = (MergeShardsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("MergeShards").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)mergeShardsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new MergeShardsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return mergeShardsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$mergeShards$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutRecordResponse putRecord(PutRecordRequest putRecordRequest) throws ResourceNotFoundException, InvalidArgumentException, ProvisionedThroughputExceededException, KmsDisabledException, KmsInvalidStateException, KmsAccessDeniedException, KmsNotFoundException, KmsOptInRequiredException, KmsThrottlingException, AccessDeniedException, InternalFailureException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRecordResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putRecordRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, putRecordRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutRecord");
            PutRecordResponse putRecordResponse = (PutRecordResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRecord").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putRecordRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutRecordRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putRecordResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$putRecord$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutRecordsResponse putRecords(PutRecordsRequest putRecordsRequest) throws ResourceNotFoundException, InvalidArgumentException, ProvisionedThroughputExceededException, KmsDisabledException, KmsInvalidStateException, KmsAccessDeniedException, KmsNotFoundException, KmsOptInRequiredException, KmsThrottlingException, AccessDeniedException, InternalFailureException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRecordsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putRecordsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, putRecordsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutRecords");
            PutRecordsResponse putRecordsResponse = (PutRecordsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRecords").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putRecordsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutRecordsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putRecordsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$putRecords$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) throws AccessDeniedException, ResourceNotFoundException, LimitExceededException, InvalidArgumentException, ResourceInUseException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, putResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutResourcePolicy");
            PutResourcePolicyResponse putResourcePolicyResponse = (PutResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$putResourcePolicy$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterStreamConsumerResponse registerStreamConsumer(RegisterStreamConsumerRequest registerStreamConsumerRequest) throws InvalidArgumentException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterStreamConsumerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerStreamConsumerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, registerStreamConsumerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterStreamConsumer");
            RegisterStreamConsumerResponse registerStreamConsumerResponse = (RegisterStreamConsumerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterStreamConsumer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)registerStreamConsumerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterStreamConsumerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerStreamConsumerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$registerStreamConsumer$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveTagsFromStreamResponse removeTagsFromStream(RemoveTagsFromStreamRequest removeTagsFromStreamRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveTagsFromStreamResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeTagsFromStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, removeTagsFromStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveTagsFromStream");
            RemoveTagsFromStreamResponse removeTagsFromStreamResponse = (RemoveTagsFromStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTagsFromStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)removeTagsFromStreamRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveTagsFromStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeTagsFromStreamResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$removeTagsFromStream$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SplitShardResponse splitShard(SplitShardRequest splitShardRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SplitShardResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)splitShardRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, splitShardRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SplitShard");
            SplitShardResponse splitShardResponse = (SplitShardResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SplitShard").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)splitShardRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SplitShardRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return splitShardResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$splitShard$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartStreamEncryptionResponse startStreamEncryption(StartStreamEncryptionRequest startStreamEncryptionRequest) throws InvalidArgumentException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, KmsDisabledException, KmsInvalidStateException, KmsAccessDeniedException, KmsNotFoundException, KmsOptInRequiredException, KmsThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartStreamEncryptionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startStreamEncryptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, startStreamEncryptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartStreamEncryption");
            StartStreamEncryptionResponse startStreamEncryptionResponse = (StartStreamEncryptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartStreamEncryption").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startStreamEncryptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartStreamEncryptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startStreamEncryptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$startStreamEncryption$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopStreamEncryptionResponse stopStreamEncryption(StopStreamEncryptionRequest stopStreamEncryptionRequest) throws InvalidArgumentException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopStreamEncryptionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopStreamEncryptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, stopStreamEncryptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopStreamEncryption");
            StopStreamEncryptionResponse stopStreamEncryptionResponse = (StopStreamEncryptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopStreamEncryption").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopStreamEncryptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopStreamEncryptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopStreamEncryptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$stopStreamEncryption$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$tagResource$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$untagResource$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateShardCountResponse updateShardCount(UpdateShardCountRequest updateShardCountRequest) throws InvalidArgumentException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateShardCountResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateShardCountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, updateShardCountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateShardCount");
            UpdateShardCountResponse updateShardCountResponse = (UpdateShardCountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateShardCount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateShardCountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateShardCountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateShardCountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$updateShardCount$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateStreamModeResponse updateStreamMode(UpdateStreamModeRequest updateStreamModeRequest) throws InvalidArgumentException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateStreamModeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "KMSThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KMSNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ExpiredIteratorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredIteratorException::builder).build());
                }
                case "KMSOptInRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "KMSAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "KMSDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateStreamModeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(clientConfiguration, updateStreamModeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateStreamMode");
            UpdateStreamModeResponse updateStreamModeResponse = (UpdateStreamModeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateStreamMode").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateStreamModeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateStreamModeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateStreamModeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisClient.lambda$updateStreamMode$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public KinesisWaiter waiter() {
        return KinesisWaiter.builder().client(this).build();
    }

    public final String serviceName() {
        return "kinesis";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        KinesisServiceClientConfigurationBuilder serviceConfigBuilder = new KinesisServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(KinesisException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final KinesisServiceClientConfiguration serviceClientConfiguration() {
        return new KinesisServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateStreamMode$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateShardCount$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopStreamEncryption$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startStreamEncryption$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$splitShard$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeTagsFromStream$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerStreamConsumer$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putResourcePolicy$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putRecords$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putRecord$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$mergeShards$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForStream$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listStreams$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listStreamConsumers$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listShards$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$increaseStreamRetentionPeriod$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getShardIterator$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourcePolicy$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRecords$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableEnhancedMonitoring$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableEnhancedMonitoring$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeStreamSummary$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeStreamConsumer$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeStream$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLimits$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterStreamConsumer$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteStream$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$decreaseStreamRetentionPeriod$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createStream$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addTagsToStream$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

