/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output for <a>GetRecords</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRecordsResponse extends KinesisResponse implements
        ToCopyableBuilder<GetRecordsResponse.Builder, GetRecordsResponse> {
    private static final SdkField<List<Record>> RECORDS_FIELD = SdkField
            .<List<Record>> builder(MarshallingType.LIST)
            .memberName("Records")
            .getter(getter(GetRecordsResponse::records))
            .setter(setter(Builder::records))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Records").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Record> builder(MarshallingType.SDK_POJO)
                                            .constructor(Record::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_SHARD_ITERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextShardIterator").getter(getter(GetRecordsResponse::nextShardIterator))
            .setter(setter(Builder::nextShardIterator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextShardIterator").build()).build();

    private static final SdkField<Long> MILLIS_BEHIND_LATEST_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MillisBehindLatest").getter(getter(GetRecordsResponse::millisBehindLatest))
            .setter(setter(Builder::millisBehindLatest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MillisBehindLatest").build())
            .build();

    private static final SdkField<List<ChildShard>> CHILD_SHARDS_FIELD = SdkField
            .<List<ChildShard>> builder(MarshallingType.LIST)
            .memberName("ChildShards")
            .getter(getter(GetRecordsResponse::childShards))
            .setter(setter(Builder::childShards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChildShards").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChildShard> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChildShard::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_FIELD,
            NEXT_SHARD_ITERATOR_FIELD, MILLIS_BEHIND_LATEST_FIELD, CHILD_SHARDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Record> records;

    private final String nextShardIterator;

    private final Long millisBehindLatest;

    private final List<ChildShard> childShards;

    private GetRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.records = builder.records;
        this.nextShardIterator = builder.nextShardIterator;
        this.millisBehindLatest = builder.millisBehindLatest;
        this.childShards = builder.childShards;
    }

    /**
     * For responses, this returns true if the service returned a value for the Records property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRecords() {
        return records != null && !(records instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data records retrieved from the shard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecords} method.
     * </p>
     * 
     * @return The data records retrieved from the shard.
     */
    public final List<Record> records() {
        return records;
    }

    /**
     * <p>
     * The next position in the shard from which to start sequentially reading data records. If set to <code>null</code>
     * , the shard has been closed and the requested iterator does not return any more data.
     * </p>
     * 
     * @return The next position in the shard from which to start sequentially reading data records. If set to
     *         <code>null</code>, the shard has been closed and the requested iterator does not return any more data.
     */
    public final String nextShardIterator() {
        return nextShardIterator;
    }

    /**
     * <p>
     * The number of milliseconds the <a>GetRecords</a> response is from the tip of the stream, indicating how far
     * behind current time the consumer is. A value of zero indicates that record processing is caught up, and there are
     * no new records to process at this moment.
     * </p>
     * 
     * @return The number of milliseconds the <a>GetRecords</a> response is from the tip of the stream, indicating how
     *         far behind current time the consumer is. A value of zero indicates that record processing is caught up,
     *         and there are no new records to process at this moment.
     */
    public final Long millisBehindLatest() {
        return millisBehindLatest;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChildShards property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChildShards() {
        return childShards != null && !(childShards instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of the current shard's child shards, returned in the <code>GetRecords</code> API's response only when
     * the end of the current shard is reached.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChildShards} method.
     * </p>
     * 
     * @return The list of the current shard's child shards, returned in the <code>GetRecords</code> API's response only
     *         when the end of the current shard is reached.
     */
    public final List<ChildShard> childShards() {
        return childShards;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRecords() ? records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextShardIterator());
        hashCode = 31 * hashCode + Objects.hashCode(millisBehindLatest());
        hashCode = 31 * hashCode + Objects.hashCode(hasChildShards() ? childShards() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecordsResponse)) {
            return false;
        }
        GetRecordsResponse other = (GetRecordsResponse) obj;
        return hasRecords() == other.hasRecords() && Objects.equals(records(), other.records())
                && Objects.equals(nextShardIterator(), other.nextShardIterator())
                && Objects.equals(millisBehindLatest(), other.millisBehindLatest()) && hasChildShards() == other.hasChildShards()
                && Objects.equals(childShards(), other.childShards());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRecordsResponse").add("Records", hasRecords() ? records() : null)
                .add("NextShardIterator", nextShardIterator()).add("MillisBehindLatest", millisBehindLatest())
                .add("ChildShards", hasChildShards() ? childShards() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Records":
            return Optional.ofNullable(clazz.cast(records()));
        case "NextShardIterator":
            return Optional.ofNullable(clazz.cast(nextShardIterator()));
        case "MillisBehindLatest":
            return Optional.ofNullable(clazz.cast(millisBehindLatest()));
        case "ChildShards":
            return Optional.ofNullable(clazz.cast(childShards()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Records", RECORDS_FIELD);
        map.put("NextShardIterator", NEXT_SHARD_ITERATOR_FIELD);
        map.put("MillisBehindLatest", MILLIS_BEHIND_LATEST_FIELD);
        map.put("ChildShards", CHILD_SHARDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRecordsResponse, T> g) {
        return obj -> g.apply((GetRecordsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRecordsResponse> {
        /**
         * <p>
         * The data records retrieved from the shard.
         * </p>
         * 
         * @param records
         *        The data records retrieved from the shard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<Record> records);

        /**
         * <p>
         * The data records retrieved from the shard.
         * </p>
         * 
         * @param records
         *        The data records retrieved from the shard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Record... records);

        /**
         * <p>
         * The data records retrieved from the shard.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kinesis.model.Record.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.kinesis.model.Record#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kinesis.model.Record.Builder#build()} is called immediately and its
         * result is passed to {@link #records(List<Record>)}.
         * 
         * @param records
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kinesis.model.Record.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #records(java.util.Collection<Record>)
         */
        Builder records(Consumer<Record.Builder>... records);

        /**
         * <p>
         * The next position in the shard from which to start sequentially reading data records. If set to
         * <code>null</code>, the shard has been closed and the requested iterator does not return any more data.
         * </p>
         * 
         * @param nextShardIterator
         *        The next position in the shard from which to start sequentially reading data records. If set to
         *        <code>null</code>, the shard has been closed and the requested iterator does not return any more data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextShardIterator(String nextShardIterator);

        /**
         * <p>
         * The number of milliseconds the <a>GetRecords</a> response is from the tip of the stream, indicating how far
         * behind current time the consumer is. A value of zero indicates that record processing is caught up, and there
         * are no new records to process at this moment.
         * </p>
         * 
         * @param millisBehindLatest
         *        The number of milliseconds the <a>GetRecords</a> response is from the tip of the stream, indicating
         *        how far behind current time the consumer is. A value of zero indicates that record processing is
         *        caught up, and there are no new records to process at this moment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder millisBehindLatest(Long millisBehindLatest);

        /**
         * <p>
         * The list of the current shard's child shards, returned in the <code>GetRecords</code> API's response only
         * when the end of the current shard is reached.
         * </p>
         * 
         * @param childShards
         *        The list of the current shard's child shards, returned in the <code>GetRecords</code> API's response
         *        only when the end of the current shard is reached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childShards(Collection<ChildShard> childShards);

        /**
         * <p>
         * The list of the current shard's child shards, returned in the <code>GetRecords</code> API's response only
         * when the end of the current shard is reached.
         * </p>
         * 
         * @param childShards
         *        The list of the current shard's child shards, returned in the <code>GetRecords</code> API's response
         *        only when the end of the current shard is reached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childShards(ChildShard... childShards);

        /**
         * <p>
         * The list of the current shard's child shards, returned in the <code>GetRecords</code> API's response only
         * when the end of the current shard is reached.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kinesis.model.ChildShard.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.kinesis.model.ChildShard#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kinesis.model.ChildShard.Builder#build()} is called immediately and
         * its result is passed to {@link #childShards(List<ChildShard>)}.
         * 
         * @param childShards
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kinesis.model.ChildShard.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #childShards(java.util.Collection<ChildShard>)
         */
        Builder childShards(Consumer<ChildShard.Builder>... childShards);
    }

    static final class BuilderImpl extends KinesisResponse.BuilderImpl implements Builder {
        private List<Record> records = DefaultSdkAutoConstructList.getInstance();

        private String nextShardIterator;

        private Long millisBehindLatest;

        private List<ChildShard> childShards = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecordsResponse model) {
            super(model);
            records(model.records);
            nextShardIterator(model.nextShardIterator);
            millisBehindLatest(model.millisBehindLatest);
            childShards(model.childShards);
        }

        public final List<Record.Builder> getRecords() {
            List<Record.Builder> result = RecordListCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<Record.BuilderImpl> records) {
            this.records = RecordListCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = RecordListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record... records) {
            records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<Record.Builder>... records) {
            records(Stream.of(records).map(c -> Record.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextShardIterator() {
            return nextShardIterator;
        }

        public final void setNextShardIterator(String nextShardIterator) {
            this.nextShardIterator = nextShardIterator;
        }

        @Override
        public final Builder nextShardIterator(String nextShardIterator) {
            this.nextShardIterator = nextShardIterator;
            return this;
        }

        public final Long getMillisBehindLatest() {
            return millisBehindLatest;
        }

        public final void setMillisBehindLatest(Long millisBehindLatest) {
            this.millisBehindLatest = millisBehindLatest;
        }

        @Override
        public final Builder millisBehindLatest(Long millisBehindLatest) {
            this.millisBehindLatest = millisBehindLatest;
            return this;
        }

        public final List<ChildShard.Builder> getChildShards() {
            List<ChildShard.Builder> result = ChildShardListCopier.copyToBuilder(this.childShards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChildShards(Collection<ChildShard.BuilderImpl> childShards) {
            this.childShards = ChildShardListCopier.copyFromBuilder(childShards);
        }

        @Override
        public final Builder childShards(Collection<ChildShard> childShards) {
            this.childShards = ChildShardListCopier.copy(childShards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder childShards(ChildShard... childShards) {
            childShards(Arrays.asList(childShards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder childShards(Consumer<ChildShard.Builder>... childShards) {
            childShards(Stream.of(childShards).map(c -> ChildShard.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetRecordsResponse build() {
            return new GetRecordsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
