/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStreamConsumerRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, DescribeStreamConsumerRequest> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamARN").getter(DescribeStreamConsumerRequest.getter(DescribeStreamConsumerRequest::streamARN)).setter(DescribeStreamConsumerRequest.setter(Builder::streamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()}).build();
    private static final SdkField<String> CONSUMER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConsumerName").getter(DescribeStreamConsumerRequest.getter(DescribeStreamConsumerRequest::consumerName)).setter(DescribeStreamConsumerRequest.setter(Builder::consumerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerName").build()}).build();
    private static final SdkField<String> CONSUMER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConsumerARN").getter(DescribeStreamConsumerRequest.getter(DescribeStreamConsumerRequest::consumerARN)).setter(DescribeStreamConsumerRequest.setter(Builder::consumerARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD, CONSUMER_NAME_FIELD, CONSUMER_ARN_FIELD));
    private final String streamARN;
    private final String consumerName;
    private final String consumerARN;

    private DescribeStreamConsumerRequest(BuilderImpl builder) {
        super(builder);
        this.streamARN = builder.streamARN;
        this.consumerName = builder.consumerName;
        this.consumerARN = builder.consumerARN;
    }

    public final String streamARN() {
        return this.streamARN;
    }

    public final String consumerName() {
        return this.consumerName;
    }

    public final String consumerARN() {
        return this.consumerARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerARN());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamConsumerRequest)) {
            return false;
        }
        DescribeStreamConsumerRequest other = (DescribeStreamConsumerRequest)((Object)obj);
        return Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.consumerName(), other.consumerName()) && Objects.equals(this.consumerARN(), other.consumerARN());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeStreamConsumerRequest").add("StreamARN", (Object)this.streamARN()).add("ConsumerName", (Object)this.consumerName()).add("ConsumerARN", (Object)this.consumerARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
            case "ConsumerName": {
                return Optional.ofNullable(clazz.cast(this.consumerName()));
            }
            case "ConsumerARN": {
                return Optional.ofNullable(clazz.cast(this.consumerARN()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStreamConsumerRequest, T> g) {
        return obj -> g.apply((DescribeStreamConsumerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamARN;
        private String consumerName;
        private String consumerARN;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamConsumerRequest model) {
            super(model);
            this.streamARN(model.streamARN);
            this.consumerName(model.consumerName);
            this.consumerARN(model.consumerARN);
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final String getConsumerName() {
            return this.consumerName;
        }

        public final void setConsumerName(String consumerName) {
            this.consumerName = consumerName;
        }

        @Override
        public final Builder consumerName(String consumerName) {
            this.consumerName = consumerName;
            return this;
        }

        public final String getConsumerARN() {
            return this.consumerARN;
        }

        public final void setConsumerARN(String consumerARN) {
            this.consumerARN = consumerARN;
        }

        @Override
        public final Builder consumerARN(String consumerARN) {
            this.consumerARN = consumerARN;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeStreamConsumerRequest build() {
            return new DescribeStreamConsumerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStreamConsumerRequest> {
        public Builder streamARN(String var1);

        public Builder consumerName(String var1);

        public Builder consumerARN(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

