/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRecordsRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, GetRecordsRequest> {
    private static final SdkField<String> SHARD_ITERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShardIterator").getter(GetRecordsRequest.getter(GetRecordsRequest::shardIterator)).setter(GetRecordsRequest.setter(Builder::shardIterator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardIterator").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(GetRecordsRequest.getter(GetRecordsRequest::limit)).setter(GetRecordsRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamARN").getter(GetRecordsRequest.getter(GetRecordsRequest::streamARN)).setter(GetRecordsRequest.setter(Builder::streamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARD_ITERATOR_FIELD, LIMIT_FIELD, STREAM_ARN_FIELD));
    private final String shardIterator;
    private final Integer limit;
    private final String streamARN;

    private GetRecordsRequest(BuilderImpl builder) {
        super(builder);
        this.shardIterator = builder.shardIterator;
        this.limit = builder.limit;
        this.streamARN = builder.streamARN;
    }

    public final String shardIterator() {
        return this.shardIterator;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String streamARN() {
        return this.streamARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.shardIterator());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecordsRequest)) {
            return false;
        }
        GetRecordsRequest other = (GetRecordsRequest)((Object)obj);
        return Objects.equals(this.shardIterator(), other.shardIterator()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.streamARN(), other.streamARN());
    }

    public final String toString() {
        return ToString.builder((String)"GetRecordsRequest").add("ShardIterator", (Object)this.shardIterator()).add("Limit", (Object)this.limit()).add("StreamARN", (Object)this.streamARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShardIterator": {
                return Optional.ofNullable(clazz.cast(this.shardIterator()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRecordsRequest, T> g) {
        return obj -> g.apply((GetRecordsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String shardIterator;
        private Integer limit;
        private String streamARN;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecordsRequest model) {
            super(model);
            this.shardIterator(model.shardIterator);
            this.limit(model.limit);
            this.streamARN(model.streamARN);
        }

        public final String getShardIterator() {
            return this.shardIterator;
        }

        public final void setShardIterator(String shardIterator) {
            this.shardIterator = shardIterator;
        }

        @Override
        public final Builder shardIterator(String shardIterator) {
            this.shardIterator = shardIterator;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRecordsRequest build() {
            return new GetRecordsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRecordsRequest> {
        public Builder shardIterator(String var1);

        public Builder limit(Integer var1);

        public Builder streamARN(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

