/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesis.model.ConsumerStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConsumerDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConsumerDescription> {
    private static final SdkField<String> CONSUMER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConsumerName").getter(ConsumerDescription.getter(ConsumerDescription::consumerName)).setter(ConsumerDescription.setter(Builder::consumerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerName").build()}).build();
    private static final SdkField<String> CONSUMER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConsumerARN").getter(ConsumerDescription.getter(ConsumerDescription::consumerARN)).setter(ConsumerDescription.setter(Builder::consumerARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerARN").build()}).build();
    private static final SdkField<String> CONSUMER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConsumerStatus").getter(ConsumerDescription.getter(ConsumerDescription::consumerStatusAsString)).setter(ConsumerDescription.setter(Builder::consumerStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerStatus").build()}).build();
    private static final SdkField<Instant> CONSUMER_CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ConsumerCreationTimestamp").getter(ConsumerDescription.getter(ConsumerDescription::consumerCreationTimestamp)).setter(ConsumerDescription.setter(Builder::consumerCreationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerCreationTimestamp").build()}).build();
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamARN").getter(ConsumerDescription.getter(ConsumerDescription::streamARN)).setter(ConsumerDescription.setter(Builder::streamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMER_NAME_FIELD, CONSUMER_ARN_FIELD, CONSUMER_STATUS_FIELD, CONSUMER_CREATION_TIMESTAMP_FIELD, STREAM_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String consumerName;
    private final String consumerARN;
    private final String consumerStatus;
    private final Instant consumerCreationTimestamp;
    private final String streamARN;

    private ConsumerDescription(BuilderImpl builder) {
        this.consumerName = builder.consumerName;
        this.consumerARN = builder.consumerARN;
        this.consumerStatus = builder.consumerStatus;
        this.consumerCreationTimestamp = builder.consumerCreationTimestamp;
        this.streamARN = builder.streamARN;
    }

    public final String consumerName() {
        return this.consumerName;
    }

    public final String consumerARN() {
        return this.consumerARN;
    }

    public final ConsumerStatus consumerStatus() {
        return ConsumerStatus.fromValue(this.consumerStatus);
    }

    public final String consumerStatusAsString() {
        return this.consumerStatus;
    }

    public final Instant consumerCreationTimestamp() {
        return this.consumerCreationTimestamp;
    }

    public final String streamARN() {
        return this.streamARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerCreationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConsumerDescription)) {
            return false;
        }
        ConsumerDescription other = (ConsumerDescription)obj;
        return Objects.equals(this.consumerName(), other.consumerName()) && Objects.equals(this.consumerARN(), other.consumerARN()) && Objects.equals(this.consumerStatusAsString(), other.consumerStatusAsString()) && Objects.equals(this.consumerCreationTimestamp(), other.consumerCreationTimestamp()) && Objects.equals(this.streamARN(), other.streamARN());
    }

    public final String toString() {
        return ToString.builder((String)"ConsumerDescription").add("ConsumerName", (Object)this.consumerName()).add("ConsumerARN", (Object)this.consumerARN()).add("ConsumerStatus", (Object)this.consumerStatusAsString()).add("ConsumerCreationTimestamp", (Object)this.consumerCreationTimestamp()).add("StreamARN", (Object)this.streamARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConsumerName": {
                return Optional.ofNullable(clazz.cast(this.consumerName()));
            }
            case "ConsumerARN": {
                return Optional.ofNullable(clazz.cast(this.consumerARN()));
            }
            case "ConsumerStatus": {
                return Optional.ofNullable(clazz.cast(this.consumerStatusAsString()));
            }
            case "ConsumerCreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.consumerCreationTimestamp()));
            }
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConsumerDescription, T> g) {
        return obj -> g.apply((ConsumerDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String consumerName;
        private String consumerARN;
        private String consumerStatus;
        private Instant consumerCreationTimestamp;
        private String streamARN;

        private BuilderImpl() {
        }

        private BuilderImpl(ConsumerDescription model) {
            this.consumerName(model.consumerName);
            this.consumerARN(model.consumerARN);
            this.consumerStatus(model.consumerStatus);
            this.consumerCreationTimestamp(model.consumerCreationTimestamp);
            this.streamARN(model.streamARN);
        }

        public final String getConsumerName() {
            return this.consumerName;
        }

        public final void setConsumerName(String consumerName) {
            this.consumerName = consumerName;
        }

        @Override
        @Transient
        public final Builder consumerName(String consumerName) {
            this.consumerName = consumerName;
            return this;
        }

        public final String getConsumerARN() {
            return this.consumerARN;
        }

        public final void setConsumerARN(String consumerARN) {
            this.consumerARN = consumerARN;
        }

        @Override
        @Transient
        public final Builder consumerARN(String consumerARN) {
            this.consumerARN = consumerARN;
            return this;
        }

        public final String getConsumerStatus() {
            return this.consumerStatus;
        }

        public final void setConsumerStatus(String consumerStatus) {
            this.consumerStatus = consumerStatus;
        }

        @Override
        @Transient
        public final Builder consumerStatus(String consumerStatus) {
            this.consumerStatus = consumerStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder consumerStatus(ConsumerStatus consumerStatus) {
            this.consumerStatus(consumerStatus == null ? null : consumerStatus.toString());
            return this;
        }

        public final Instant getConsumerCreationTimestamp() {
            return this.consumerCreationTimestamp;
        }

        public final void setConsumerCreationTimestamp(Instant consumerCreationTimestamp) {
            this.consumerCreationTimestamp = consumerCreationTimestamp;
        }

        @Override
        @Transient
        public final Builder consumerCreationTimestamp(Instant consumerCreationTimestamp) {
            this.consumerCreationTimestamp = consumerCreationTimestamp;
            return this;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        @Transient
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public ConsumerDescription build() {
            return new ConsumerDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConsumerDescription> {
        public Builder consumerName(String var1);

        public Builder consumerARN(String var1);

        public Builder consumerStatus(String var1);

        public Builder consumerStatus(ConsumerStatus var1);

        public Builder consumerCreationTimestamp(Instant var1);

        public Builder streamARN(String var1);
    }
}

