/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesis.model.ChildShard;
import software.amazon.awssdk.services.kinesis.model.ChildShardListCopier;
import software.amazon.awssdk.services.kinesis.model.KinesisResponse;
import software.amazon.awssdk.services.kinesis.model.Record;
import software.amazon.awssdk.services.kinesis.model.RecordListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRecordsResponse
extends KinesisResponse
implements ToCopyableBuilder<Builder, GetRecordsResponse> {
    private static final SdkField<List<Record>> RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Records").getter(GetRecordsResponse.getter(GetRecordsResponse::records)).setter(GetRecordsResponse.setter(Builder::records)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Records").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Record::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_SHARD_ITERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextShardIterator").getter(GetRecordsResponse.getter(GetRecordsResponse::nextShardIterator)).setter(GetRecordsResponse.setter(Builder::nextShardIterator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextShardIterator").build()}).build();
    private static final SdkField<Long> MILLIS_BEHIND_LATEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MillisBehindLatest").getter(GetRecordsResponse.getter(GetRecordsResponse::millisBehindLatest)).setter(GetRecordsResponse.setter(Builder::millisBehindLatest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MillisBehindLatest").build()}).build();
    private static final SdkField<List<ChildShard>> CHILD_SHARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChildShards").getter(GetRecordsResponse.getter(GetRecordsResponse::childShards)).setter(GetRecordsResponse.setter(Builder::childShards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChildShards").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChildShard::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_FIELD, NEXT_SHARD_ITERATOR_FIELD, MILLIS_BEHIND_LATEST_FIELD, CHILD_SHARDS_FIELD));
    private final List<Record> records;
    private final String nextShardIterator;
    private final Long millisBehindLatest;
    private final List<ChildShard> childShards;

    private GetRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.records = builder.records;
        this.nextShardIterator = builder.nextShardIterator;
        this.millisBehindLatest = builder.millisBehindLatest;
        this.childShards = builder.childShards;
    }

    public boolean hasRecords() {
        return this.records != null && !(this.records instanceof SdkAutoConstructList);
    }

    public List<Record> records() {
        return this.records;
    }

    public String nextShardIterator() {
        return this.nextShardIterator;
    }

    public Long millisBehindLatest() {
        return this.millisBehindLatest;
    }

    public boolean hasChildShards() {
        return this.childShards != null && !(this.childShards instanceof SdkAutoConstructList);
    }

    public List<ChildShard> childShards() {
        return this.childShards;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.records());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextShardIterator());
        hashCode = 31 * hashCode + Objects.hashCode(this.millisBehindLatest());
        hashCode = 31 * hashCode + Objects.hashCode(this.childShards());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecordsResponse)) {
            return false;
        }
        GetRecordsResponse other = (GetRecordsResponse)((Object)obj);
        return Objects.equals(this.records(), other.records()) && Objects.equals(this.nextShardIterator(), other.nextShardIterator()) && Objects.equals(this.millisBehindLatest(), other.millisBehindLatest()) && Objects.equals(this.childShards(), other.childShards());
    }

    public String toString() {
        return ToString.builder((String)"GetRecordsResponse").add("Records", this.records()).add("NextShardIterator", (Object)this.nextShardIterator()).add("MillisBehindLatest", (Object)this.millisBehindLatest()).add("ChildShards", this.childShards()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Records": {
                return Optional.ofNullable(clazz.cast(this.records()));
            }
            case "NextShardIterator": {
                return Optional.ofNullable(clazz.cast(this.nextShardIterator()));
            }
            case "MillisBehindLatest": {
                return Optional.ofNullable(clazz.cast(this.millisBehindLatest()));
            }
            case "ChildShards": {
                return Optional.ofNullable(clazz.cast(this.childShards()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRecordsResponse, T> g) {
        return obj -> g.apply((GetRecordsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisResponse.BuilderImpl
    implements Builder {
        private List<Record> records = DefaultSdkAutoConstructList.getInstance();
        private String nextShardIterator;
        private Long millisBehindLatest;
        private List<ChildShard> childShards = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecordsResponse model) {
            super(model);
            this.records(model.records);
            this.nextShardIterator(model.nextShardIterator);
            this.millisBehindLatest(model.millisBehindLatest);
            this.childShards(model.childShards);
        }

        public final Collection<Record.Builder> getRecords() {
            return this.records != null ? (Collection)this.records.stream().map(Record::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = RecordListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<Record.Builder> ... records) {
            this.records(Stream.of(records).map(c -> (Record)((Record.Builder)Record.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecords(Collection<Record.BuilderImpl> records) {
            this.records = RecordListCopier.copyFromBuilder(records);
        }

        public final String getNextShardIterator() {
            return this.nextShardIterator;
        }

        @Override
        public final Builder nextShardIterator(String nextShardIterator) {
            this.nextShardIterator = nextShardIterator;
            return this;
        }

        public final void setNextShardIterator(String nextShardIterator) {
            this.nextShardIterator = nextShardIterator;
        }

        public final Long getMillisBehindLatest() {
            return this.millisBehindLatest;
        }

        @Override
        public final Builder millisBehindLatest(Long millisBehindLatest) {
            this.millisBehindLatest = millisBehindLatest;
            return this;
        }

        public final void setMillisBehindLatest(Long millisBehindLatest) {
            this.millisBehindLatest = millisBehindLatest;
        }

        public final Collection<ChildShard.Builder> getChildShards() {
            return this.childShards != null ? (Collection)this.childShards.stream().map(ChildShard::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder childShards(Collection<ChildShard> childShards) {
            this.childShards = ChildShardListCopier.copy(childShards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder childShards(ChildShard ... childShards) {
            this.childShards(Arrays.asList(childShards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder childShards(Consumer<ChildShard.Builder> ... childShards) {
            this.childShards(Stream.of(childShards).map(c -> (ChildShard)((ChildShard.Builder)ChildShard.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setChildShards(Collection<ChildShard.BuilderImpl> childShards) {
            this.childShards = ChildShardListCopier.copyFromBuilder(childShards);
        }

        @Override
        public GetRecordsResponse build() {
            return new GetRecordsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRecordsResponse> {
        public Builder records(Collection<Record> var1);

        public Builder records(Record ... var1);

        public Builder records(Consumer<Record.Builder> ... var1);

        public Builder nextShardIterator(String var1);

        public Builder millisBehindLatest(Long var1);

        public Builder childShards(Collection<ChildShard> var1);

        public Builder childShards(ChildShard ... var1);

        public Builder childShards(Consumer<ChildShard.Builder> ... var1);
    }
}

