/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStreamConsumerRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, DescribeStreamConsumerRequest> {
    private final String streamARN;
    private final String consumerName;
    private final String consumerARN;

    private DescribeStreamConsumerRequest(BuilderImpl builder) {
        super(builder);
        this.streamARN = builder.streamARN;
        this.consumerName = builder.consumerName;
        this.consumerARN = builder.consumerARN;
    }

    public String streamARN() {
        return this.streamARN;
    }

    public String consumerName() {
        return this.consumerName;
    }

    public String consumerARN() {
        return this.consumerARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamConsumerRequest)) {
            return false;
        }
        DescribeStreamConsumerRequest other = (DescribeStreamConsumerRequest)((Object)obj);
        return Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.consumerName(), other.consumerName()) && Objects.equals(this.consumerARN(), other.consumerARN());
    }

    public String toString() {
        return ToString.builder((String)"DescribeStreamConsumerRequest").add("StreamARN", (Object)this.streamARN()).add("ConsumerName", (Object)this.consumerName()).add("ConsumerARN", (Object)this.consumerARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
            case "ConsumerName": {
                return Optional.ofNullable(clazz.cast(this.consumerName()));
            }
            case "ConsumerARN": {
                return Optional.ofNullable(clazz.cast(this.consumerARN()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamARN;
        private String consumerName;
        private String consumerARN;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamConsumerRequest model) {
            super(model);
            this.streamARN(model.streamARN);
            this.consumerName(model.consumerName);
            this.consumerARN(model.consumerARN);
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        public final String getConsumerName() {
            return this.consumerName;
        }

        @Override
        public final Builder consumerName(String consumerName) {
            this.consumerName = consumerName;
            return this;
        }

        public final void setConsumerName(String consumerName) {
            this.consumerName = consumerName;
        }

        public final String getConsumerARN() {
            return this.consumerARN;
        }

        @Override
        public final Builder consumerARN(String consumerARN) {
            this.consumerARN = consumerARN;
            return this;
        }

        public final void setConsumerARN(String consumerARN) {
            this.consumerARN = consumerARN;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeStreamConsumerRequest build() {
            return new DescribeStreamConsumerRequest(this);
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    CopyableBuilder<Builder, DescribeStreamConsumerRequest> {
        public Builder streamARN(String var1);

        public Builder consumerName(String var1);

        public Builder consumerARN(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

