/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RemoveTagsFromStreamRequestModelMarshaller {
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamName").isBinary(false).build();
    private static final MarshallingInfo<List> TAGKEYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TagKeys").isBinary(false).build();
    private static final RemoveTagsFromStreamRequestModelMarshaller INSTANCE = new RemoveTagsFromStreamRequestModelMarshaller();

    private RemoveTagsFromStreamRequestModelMarshaller() {
    }

    public static RemoveTagsFromStreamRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RemoveTagsFromStreamRequest removeTagsFromStreamRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)removeTagsFromStreamRequest), (String)"removeTagsFromStreamRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)removeTagsFromStreamRequest.streamName(), STREAMNAME_BINDING);
            protocolMarshaller.marshall(removeTagsFromStreamRequest.tagKeys(), TAGKEYS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

