/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.ListStreamConsumersRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListStreamConsumersRequestModelMarshaller {
    private static final MarshallingInfo<String> STREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamARN").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").isBinary(false).build();
    private static final MarshallingInfo<Instant> STREAMCREATIONTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamCreationTimestamp").isBinary(false).build();
    private static final ListStreamConsumersRequestModelMarshaller INSTANCE = new ListStreamConsumersRequestModelMarshaller();

    private ListStreamConsumersRequestModelMarshaller() {
    }

    public static ListStreamConsumersRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListStreamConsumersRequest listStreamConsumersRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listStreamConsumersRequest), (String)"listStreamConsumersRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listStreamConsumersRequest.streamARN(), STREAMARN_BINDING);
            protocolMarshaller.marshall((Object)listStreamConsumersRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)listStreamConsumersRequest.maxResults(), MAXRESULTS_BINDING);
            protocolMarshaller.marshall((Object)listStreamConsumersRequest.streamCreationTimestamp(), STREAMCREATIONTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

