/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.kinesis.model.KinesisResponse;
import software.amazon.awssdk.services.kinesis.model.Shard;
import software.amazon.awssdk.services.kinesis.model.ShardListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListShardsResponse
extends KinesisResponse
implements ToCopyableBuilder<Builder, ListShardsResponse> {
    private final List<Shard> shards;
    private final String nextToken;

    private ListShardsResponse(BuilderImpl builder) {
        super(builder);
        this.shards = builder.shards;
        this.nextToken = builder.nextToken;
    }

    public List<Shard> shards() {
        return this.shards;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.shards());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListShardsResponse)) {
            return false;
        }
        ListShardsResponse other = (ListShardsResponse)((Object)obj);
        return Objects.equals(this.shards(), other.shards()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListShardsResponse").add("Shards", this.shards()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Shards": {
                return Optional.ofNullable(clazz.cast(this.shards()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisResponse.BuilderImpl
    implements Builder {
        private List<Shard> shards = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListShardsResponse model) {
            super(model);
            this.shards(model.shards);
            this.nextToken(model.nextToken);
        }

        public final Collection<Shard.Builder> getShards() {
            return this.shards != null ? (Collection)this.shards.stream().map(Shard::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder shards(Collection<Shard> shards) {
            this.shards = ShardListCopier.copy(shards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shards(Shard ... shards) {
            this.shards(Arrays.asList(shards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shards(Consumer<Shard.Builder> ... shards) {
            this.shards(Stream.of(shards).map(c -> (Shard)((Shard.Builder)Shard.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setShards(Collection<Shard.BuilderImpl> shards) {
            this.shards = ShardListCopier.copyFromBuilder(shards);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListShardsResponse build() {
            return new ListShardsResponse(this);
        }
    }

    public static interface Builder
    extends KinesisResponse.Builder,
    CopyableBuilder<Builder, ListShardsResponse> {
        public Builder shards(Collection<Shard> var1);

        public Builder shards(Shard ... var1);

        public Builder shards(Consumer<Shard.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

