/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.ListShardsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListShardsRequestModelMarshaller {
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamName").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final MarshallingInfo<String> EXCLUSIVESTARTSHARDID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExclusiveStartShardId").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").isBinary(false).build();
    private static final MarshallingInfo<Instant> STREAMCREATIONTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamCreationTimestamp").isBinary(false).build();
    private static final ListShardsRequestModelMarshaller INSTANCE = new ListShardsRequestModelMarshaller();

    private ListShardsRequestModelMarshaller() {
    }

    public static ListShardsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListShardsRequest listShardsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listShardsRequest), (String)"listShardsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listShardsRequest.streamName(), STREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)listShardsRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)listShardsRequest.exclusiveStartShardId(), EXCLUSIVESTARTSHARDID_BINDING);
            protocolMarshaller.marshall((Object)listShardsRequest.maxResults(), MAXRESULTS_BINDING);
            protocolMarshaller.marshall((Object)listShardsRequest.streamCreationTimestamp(), STREAMCREATIONTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

