/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.Consumer;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConsumerMarshaller {
    private static final MarshallingInfo<String> CONSUMERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerName").isBinary(false).build();
    private static final MarshallingInfo<String> CONSUMERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerARN").isBinary(false).build();
    private static final MarshallingInfo<String> CONSUMERSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerStatus").isBinary(false).build();
    private static final MarshallingInfo<Instant> CONSUMERCREATIONTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerCreationTimestamp").isBinary(false).build();
    private static final ConsumerMarshaller INSTANCE = new ConsumerMarshaller();

    private ConsumerMarshaller() {
    }

    public static ConsumerMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Consumer consumer, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)consumer, (String)"consumer");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)consumer.consumerName(), CONSUMERNAME_BINDING);
            protocolMarshaller.marshall((Object)consumer.consumerARN(), CONSUMERARN_BINDING);
            protocolMarshaller.marshall((Object)consumer.consumerStatusAsString(), CONSUMERSTATUS_BINDING);
            protocolMarshaller.marshall((Object)consumer.consumerCreationTimestamp(), CONSUMERCREATIONTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

