/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequestEntry;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequestEntryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRecordsRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, PutRecordsRequest> {
    private final List<PutRecordsRequestEntry> records;
    private final String streamName;

    private PutRecordsRequest(BuilderImpl builder) {
        super(builder);
        this.records = builder.records;
        this.streamName = builder.streamName;
    }

    public List<PutRecordsRequestEntry> records() {
        return this.records;
    }

    public String streamName() {
        return this.streamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.records());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordsRequest)) {
            return false;
        }
        PutRecordsRequest other = (PutRecordsRequest)((Object)obj);
        return Objects.equals(this.records(), other.records()) && Objects.equals(this.streamName(), other.streamName());
    }

    public String toString() {
        return ToString.builder((String)"PutRecordsRequest").add("Records", this.records()).add("StreamName", (Object)this.streamName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Records": {
                return Optional.ofNullable(clazz.cast(this.records()));
            }
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private List<PutRecordsRequestEntry> records = DefaultSdkAutoConstructList.getInstance();
        private String streamName;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordsRequest model) {
            super(model);
            this.records(model.records);
            this.streamName(model.streamName);
        }

        public final Collection<PutRecordsRequestEntry.Builder> getRecords() {
            return this.records != null ? (Collection)this.records.stream().map(PutRecordsRequestEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder records(Collection<PutRecordsRequestEntry> records) {
            this.records = PutRecordsRequestEntryListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(PutRecordsRequestEntry ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<PutRecordsRequestEntry.Builder> ... records) {
            this.records(Stream.of(records).map(c -> (PutRecordsRequestEntry)((PutRecordsRequestEntry.Builder)PutRecordsRequestEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecords(Collection<PutRecordsRequestEntry.BuilderImpl> records) {
            this.records = PutRecordsRequestEntryListCopier.copyFromBuilder(records);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRecordsRequest build() {
            return new PutRecordsRequest(this);
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    CopyableBuilder<Builder, PutRecordsRequest> {
        public Builder records(Collection<PutRecordsRequestEntry> var1);

        public Builder records(PutRecordsRequestEntry ... var1);

        public Builder records(Consumer<PutRecordsRequestEntry.Builder> ... var1);

        public Builder streamName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

