/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteStreamRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, DeleteStreamRequest> {
    private final String streamName;
    private final Boolean enforceConsumerDeletion;

    private DeleteStreamRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.enforceConsumerDeletion = builder.enforceConsumerDeletion;
    }

    public String streamName() {
        return this.streamName;
    }

    public Boolean enforceConsumerDeletion() {
        return this.enforceConsumerDeletion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.enforceConsumerDeletion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteStreamRequest)) {
            return false;
        }
        DeleteStreamRequest other = (DeleteStreamRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.enforceConsumerDeletion(), other.enforceConsumerDeletion());
    }

    public String toString() {
        return ToString.builder((String)"DeleteStreamRequest").add("StreamName", (Object)this.streamName()).add("EnforceConsumerDeletion", (Object)this.enforceConsumerDeletion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "EnforceConsumerDeletion": {
                return Optional.ofNullable(clazz.cast(this.enforceConsumerDeletion()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private Boolean enforceConsumerDeletion;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteStreamRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.enforceConsumerDeletion(model.enforceConsumerDeletion);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Boolean getEnforceConsumerDeletion() {
            return this.enforceConsumerDeletion;
        }

        @Override
        public final Builder enforceConsumerDeletion(Boolean enforceConsumerDeletion) {
            this.enforceConsumerDeletion = enforceConsumerDeletion;
            return this;
        }

        public final void setEnforceConsumerDeletion(Boolean enforceConsumerDeletion) {
            this.enforceConsumerDeletion = enforceConsumerDeletion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteStreamRequest build() {
            return new DeleteStreamRequest(this);
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    CopyableBuilder<Builder, DeleteStreamRequest> {
        public Builder streamName(String var1);

        public Builder enforceConsumerDeletion(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

