/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceUpdate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReferenceDataSourceUpdateMarshaller {
    private static final MarshallingInfo<String> REFERENCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceId").isBinary(false).build();
    private static final MarshallingInfo<String> TABLENAMEUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableNameUpdate").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> S3REFERENCEDATASOURCEUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3ReferenceDataSourceUpdate").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> REFERENCESCHEMAUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceSchemaUpdate").isBinary(false).build();
    private static final ReferenceDataSourceUpdateMarshaller INSTANCE = new ReferenceDataSourceUpdateMarshaller();

    private ReferenceDataSourceUpdateMarshaller() {
    }

    public static ReferenceDataSourceUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReferenceDataSourceUpdate referenceDataSourceUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)referenceDataSourceUpdate, (String)"referenceDataSourceUpdate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)referenceDataSourceUpdate.referenceId(), REFERENCEID_BINDING);
            protocolMarshaller.marshall((Object)referenceDataSourceUpdate.tableNameUpdate(), TABLENAMEUPDATE_BINDING);
            protocolMarshaller.marshall((Object)referenceDataSourceUpdate.s3ReferenceDataSourceUpdate(), S3REFERENCEDATASOURCEUPDATE_BINDING);
            protocolMarshaller.marshall((Object)referenceDataSourceUpdate.referenceSchemaUpdate(), REFERENCESCHEMAUPDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

