/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReferenceDataSourceDescriptionMarshaller {
    private static final MarshallingInfo<String> REFERENCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceId").isBinary(false).build();
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> S3REFERENCEDATASOURCEDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3ReferenceDataSourceDescription").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> REFERENCESCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceSchema").isBinary(false).build();
    private static final ReferenceDataSourceDescriptionMarshaller INSTANCE = new ReferenceDataSourceDescriptionMarshaller();

    private ReferenceDataSourceDescriptionMarshaller() {
    }

    public static ReferenceDataSourceDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReferenceDataSourceDescription referenceDataSourceDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)referenceDataSourceDescription, (String)"referenceDataSourceDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)referenceDataSourceDescription.referenceId(), REFERENCEID_BINDING);
            protocolMarshaller.marshall((Object)referenceDataSourceDescription.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall((Object)referenceDataSourceDescription.s3ReferenceDataSourceDescription(), S3REFERENCEDATASOURCEDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)referenceDataSourceDescription.referenceSchema(), REFERENCESCHEMA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

