/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.OutputUpdate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OutputUpdateMarshaller {
    private static final MarshallingInfo<String> OUTPUTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputId").isBinary(false).build();
    private static final MarshallingInfo<String> NAMEUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NameUpdate").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSOUTPUTUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisStreamsOutputUpdate").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> KINESISFIREHOSEOUTPUTUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisFirehoseOutputUpdate").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DESTINATIONSCHEMAUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationSchemaUpdate").isBinary(false).build();
    private static final OutputUpdateMarshaller INSTANCE = new OutputUpdateMarshaller();

    private OutputUpdateMarshaller() {
    }

    public static OutputUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OutputUpdate outputUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)outputUpdate, (String)"outputUpdate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)outputUpdate.outputId(), OUTPUTID_BINDING);
            protocolMarshaller.marshall((Object)outputUpdate.nameUpdate(), NAMEUPDATE_BINDING);
            protocolMarshaller.marshall((Object)outputUpdate.kinesisStreamsOutputUpdate(), KINESISSTREAMSOUTPUTUPDATE_BINDING);
            protocolMarshaller.marshall((Object)outputUpdate.kinesisFirehoseOutputUpdate(), KINESISFIREHOSEOUTPUTUPDATE_BINDING);
            protocolMarshaller.marshall((Object)outputUpdate.destinationSchemaUpdate(), DESTINATIONSCHEMAUPDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

