/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.CSVMappingParameters;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CSVMappingParametersMarshaller {
    private static final MarshallingInfo<String> RECORDROWDELIMITER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordRowDelimiter").isBinary(false).build();
    private static final MarshallingInfo<String> RECORDCOLUMNDELIMITER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordColumnDelimiter").isBinary(false).build();
    private static final CSVMappingParametersMarshaller INSTANCE = new CSVMappingParametersMarshaller();

    private CSVMappingParametersMarshaller() {
    }

    public static CSVMappingParametersMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CSVMappingParameters csvMappingParameters, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)csvMappingParameters, (String)"csvMappingParameters");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)csvMappingParameters.recordRowDelimiter(), RECORDROWDELIMITER_BINDING);
            protocolMarshaller.marshall((Object)csvMappingParameters.recordColumnDelimiter(), RECORDCOLUMNDELIMITER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

