/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesis.transform.HashKeyRangeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HashKeyRange
implements StructuredPojo,
ToCopyableBuilder<Builder, HashKeyRange> {
    private final String startingHashKey;
    private final String endingHashKey;

    private HashKeyRange(BuilderImpl builder) {
        this.startingHashKey = builder.startingHashKey;
        this.endingHashKey = builder.endingHashKey;
    }

    public String startingHashKey() {
        return this.startingHashKey;
    }

    public String endingHashKey() {
        return this.endingHashKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startingHashKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.endingHashKey());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HashKeyRange)) {
            return false;
        }
        HashKeyRange other = (HashKeyRange)obj;
        return Objects.equals(this.startingHashKey(), other.startingHashKey()) && Objects.equals(this.endingHashKey(), other.endingHashKey());
    }

    public String toString() {
        return ToString.builder((String)"HashKeyRange").add("StartingHashKey", (Object)this.startingHashKey()).add("EndingHashKey", (Object)this.endingHashKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartingHashKey": {
                return Optional.of(clazz.cast(this.startingHashKey()));
            }
            case "EndingHashKey": {
                return Optional.of(clazz.cast(this.endingHashKey()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HashKeyRangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String startingHashKey;
        private String endingHashKey;

        private BuilderImpl() {
        }

        private BuilderImpl(HashKeyRange model) {
            this.startingHashKey(model.startingHashKey);
            this.endingHashKey(model.endingHashKey);
        }

        public final String getStartingHashKey() {
            return this.startingHashKey;
        }

        @Override
        public final Builder startingHashKey(String startingHashKey) {
            this.startingHashKey = startingHashKey;
            return this;
        }

        public final void setStartingHashKey(String startingHashKey) {
            this.startingHashKey = startingHashKey;
        }

        public final String getEndingHashKey() {
            return this.endingHashKey;
        }

        @Override
        public final Builder endingHashKey(String endingHashKey) {
            this.endingHashKey = endingHashKey;
            return this;
        }

        public final void setEndingHashKey(String endingHashKey) {
            this.endingHashKey = endingHashKey;
        }

        public HashKeyRange build() {
            return new HashKeyRange(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HashKeyRange> {
        public Builder startingHashKey(String var1);

        public Builder endingHashKey(String var1);
    }
}

